/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.survey;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogAnnotationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogSurveyRequestParameter;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyRequestParameter;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileLogAnnotation;

public class OSSUnityCatalogServerSurveyBase
extends SurveyActionServiceConnector {
    private static final String fullNameProperty = "Full Name";
    private static final String descriptionProperty = "Description";
    private static final String creationDateProperty = "Creation Date";
    private static final String createdByProperty = "Created By";
    private static final String lastUpdateProperty = "Last Update Date";
    private static final String lastUpdatedByProperty = "Last Updated By";
    private static final String deployedImplementationTypeProperty = "Deployed Implementation Type";
    protected String finalAnalysisStep = AnalysisStep.PRODUCE_INVENTORY.getName();

    protected void setFinalAnalysisStep() throws ConnectorCheckedException {
        if (this.connectionProperties.getConfigurationProperties() != null) {
            Object finalAnalysisStepPropertyObject = this.connectionProperties.getConfigurationProperties().get(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getName());
            if (finalAnalysisStepPropertyObject != null) {
                this.finalAnalysisStep = finalAnalysisStepPropertyObject.toString();
            }
            if (this.surveyContext.getRequestParameters() != null && this.surveyContext.getRequestParameters().get(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getName()) != null) {
                this.finalAnalysisStep = (String)this.surveyContext.getRequestParameters().get(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getName());
            }
        }
    }

    protected ResourceProfileAnnotation getNameListAnnotation(AnnotationType annotationType, Map<String, ResourceProperties> nameProperties) {
        HashMap<String, String> nameList = new HashMap<String, String>();
        if (nameProperties != null) {
            for (String name : nameProperties.keySet()) {
                nameList.put(name, nameProperties.get((Object)name).description);
            }
        }
        ResourceProfileAnnotation resourceProfileAnnotation = new ResourceProfileAnnotation();
        this.setUpAnnotation((Annotation)resourceProfileAnnotation, annotationType);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
        resourceProfileAnnotation.setProfilePropertyNames(propertyNames);
        resourceProfileAnnotation.setProfileProperties(nameList);
        return resourceProfileAnnotation;
    }

    protected String getCatalogName() throws ConnectorCheckedException {
        String catalogNameProperty;
        Object catalogNamePropertyObject;
        String methodName = "getCatalogName";
        String catalogName = null;
        if (this.connectionProperties.getConfigurationProperties() != null && (catalogNamePropertyObject = this.connectionProperties.getConfigurationProperties().get(UnityCatalogConfigurationProperty.CATALOG_NAME.getName())) != null) {
            catalogName = catalogNamePropertyObject.toString();
        }
        if (this.surveyContext.getRequestParameters() != null && (catalogNameProperty = (String)this.surveyContext.getRequestParameters().get(UnityCatalogSurveyRequestParameter.CATALOG_NAME.getName())) != null) {
            catalogName = catalogNameProperty;
        }
        if (catalogName != null) {
            return catalogName;
        }
        throw new ConnectorCheckedException(UCErrorCode.MISSING_PROPERTY_NAME.getMessageDefinition(this.surveyActionServiceName, UnityCatalogSurveyRequestParameter.CATALOG_NAME.getName()), ((Object)((Object)this)).getClass().getName(), "getCatalogName");
    }

    protected String getSchemaName() throws ConnectorCheckedException {
        String schemaNameProperty;
        Object schemaNamePropertyObject;
        String methodName = "getSchemaName";
        String schemaName = null;
        if (this.connectionProperties.getConfigurationProperties() != null && (schemaNamePropertyObject = this.connectionProperties.getConfigurationProperties().get(UnityCatalogConfigurationProperty.SCHEMA_NAME.getName())) != null) {
            schemaName = schemaNamePropertyObject.toString();
        }
        if (this.surveyContext.getRequestParameters() != null && (schemaNameProperty = (String)this.surveyContext.getRequestParameters().get(UnityCatalogSurveyRequestParameter.SCHEMA_NAME.getName())) != null) {
            schemaName = schemaNameProperty;
        }
        if (schemaName != null) {
            return schemaName;
        }
        throw new ConnectorCheckedException(UCErrorCode.MISSING_PROPERTY_NAME.getMessageDefinition(this.surveyActionServiceName, UnityCatalogSurveyRequestParameter.SCHEMA_NAME.getName()), ((Object)((Object)this)).getClass().getName(), "getSchemaName");
    }

    protected void writeInventory(String inventoryName, Map<String, ResourceProperties> catalogList, Map<String, ResourceProperties> schemaList, Map<String, ResourceProperties> functionList, Map<String, ResourceProperties> tableList, Map<String, ResourceProperties> volumeList) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException {
        List<String> propertyNames = Arrays.asList(fullNameProperty, descriptionProperty, creationDateProperty, createdByProperty, lastUpdateProperty, lastUpdatedByProperty, deployedImplementationTypeProperty);
        ArrayList<Map<String, String>> propertyList = new ArrayList<Map<String, String>>();
        this.addResourcesToPropertyList(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType(), catalogList, propertyList);
        this.addResourcesToPropertyList(UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType(), schemaList, propertyList);
        this.addResourcesToPropertyList(UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType(), tableList, propertyList);
        this.addResourcesToPropertyList(UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType(), functionList, propertyList);
        this.addResourcesToPropertyList(UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType(), volumeList, propertyList);
        ResourceProfileLogAnnotation annotation = super.writePropertyListInventory((AnnotationType)UnityCatalogAnnotationType.RESOURCE_INVENTORY, inventoryName, propertyNames, propertyList, this.surveyContext.getAnnotationStore().getSurveyReportGUID());
        this.surveyContext.getAnnotationStore().addAnnotation((Annotation)annotation, null);
    }

    private void addResourcesToPropertyList(String deployedImplementationType, Map<String, ResourceProperties> resourceList, List<Map<String, String>> propertyList) {
        if (resourceList != null) {
            for (String name : resourceList.keySet()) {
                ResourceProperties resourceProperties;
                if (name == null || (resourceProperties = resourceList.get(name)) == null) continue;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(fullNameProperty, name);
                properties.put(descriptionProperty, resourceProperties.description);
                properties.put(creationDateProperty, resourceProperties.creationDate.toString());
                if (resourceProperties.createdBy != null) {
                    properties.put(createdByProperty, resourceProperties.createdBy);
                } else {
                    properties.put(createdByProperty, "???");
                }
                if (resourceProperties.lastUpdateDate != null) {
                    properties.put(lastUpdateProperty, resourceProperties.lastUpdateDate.toString());
                } else {
                    properties.put(lastUpdateProperty, "---");
                }
                if (resourceProperties.lastUpdatedBy != null) {
                    properties.put(lastUpdatedByProperty, resourceProperties.lastUpdatedBy);
                } else {
                    properties.put(lastUpdatedByProperty, "???");
                }
                properties.put(deployedImplementationTypeProperty, deployedImplementationType);
                propertyList.add(properties);
            }
        }
    }

    protected static class ResourceProperties {
        protected String description = null;
        protected Date creationDate = null;
        protected String createdBy = null;
        protected Date lastUpdateDate = null;
        protected String lastUpdatedBy = null;
        protected String owner = null;

        public ResourceProperties() {
        }

        public ResourceProperties(ResourceProperties template) {
            this.description = template.description;
            this.creationDate = template.creationDate;
            this.createdBy = template.createdBy;
            this.lastUpdateDate = template.lastUpdateDate;
            this.lastUpdatedBy = template.lastUpdatedBy;
            this.owner = template.owner;
        }
    }
}

