/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.RegisteredModelInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.MetadataCollectionIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogInsideCatalogSyncRegisteredModels
extends OSSUnityCatalogInsideCatalogSyncBase {
    private final String entityTypeName;
    private String templateGUID;

    public OSSUnityCatalogInsideCatalogSyncRegisteredModels(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogGUID, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, catalogGUID, catalogName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL, templates, configurationProperties, excludeNames, includeNames, auditLog);
        this.entityTypeName = OpenMetadataType.DEPLOYED_ANALYTICS_MODEL.typeName;
        this.templateGUID = null;
        if (templates != null) {
            this.templateGUID = templates.get(this.deployedImplementationType.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaRegisteredModels";
        MetadataCollectionIterator modelIterator = new MetadataCollectionIterator(this.catalogGUID, this.catalogQualifiedName, this.catalogGUID, this.catalogQualifiedName, this.catalogName, this.connectorName, this.entityTypeName, this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (modelIterator.moreToReceive()) {
            MemberElement nextElement = modelIterator.getNextMember();
            if (nextElement == null) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeriaRegisteredModels");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            RegisteredModelInfo registeredModelInfo = null;
            String modelName = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.RESOURCE_NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeriaRegisteredModels");
            if (!this.context.elementShouldBeCatalogued(modelName, this.excludeNames, this.includeNames)) continue;
            try {
                registeredModelInfo = this.ucConnector.getRegisteredModel(modelName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MemberAction memberAction = MemberAction.NO_ACTION;
            if (registeredModelInfo == null) {
                memberAction = nextElement.getMemberAction(null, null);
            } else if (this.noMismatchInExternalIdentifier(registeredModelInfo.getId(), nextElement)) {
                memberAction = nextElement.getMemberAction(this.getDateFromLong(registeredModelInfo.getCreated_at()), this.getDateFromLong(registeredModelInfo.getUpdated_at()));
            }
            this.takeAction(this.context.getAnchorGUID(nextElement.getElement()), super.getUCSchemaFromMember(nextElement), memberAction, nextElement, registeredModelInfo);
        }
        return modelIterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaInfo> ucSchemaList = this.ucConnector.listSchemas(this.catalogName);
        if (ucSchemaList != null) {
            for (SchemaInfo schemaInfo : ucSchemaList) {
                List<RegisteredModelInfo> infoList;
                String schemaGUID;
                if (schemaInfo == null || (schemaGUID = (String)this.ucFullNameToEgeriaGUID.get(schemaInfo.getFull_name())) == null || (infoList = this.ucConnector.listRegisteredModels(this.catalogName, schemaInfo.getName())) == null) continue;
                for (RegisteredModelInfo modelInfo : infoList) {
                    if (modelInfo == null || this.ucFullNameToEgeriaGUID.get(modelInfo.getFull_name()) != null) continue;
                    String ucModelQualifiedName = this.getQualifiedName(modelInfo.getFull_name());
                    MemberElement memberElement = iterator.getMemberByQualifiedName(ucModelQualifiedName);
                    MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(modelInfo.getCreated_at()), this.getDateFromLong(modelInfo.getUpdated_at()));
                    if (!this.noMismatchInExternalIdentifier(modelInfo.getId(), memberElement)) continue;
                    this.takeAction(schemaGUID, modelInfo.getSchema_name(), memberAction, memberElement, modelInfo);
                }
            }
        }
    }

    private void takeAction(String schemaGUID, String schemaName, MemberAction memberAction, MemberElement memberElement, RegisteredModelInfo modelInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(schemaGUID, modelInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(modelInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(schemaName, memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(modelInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(modelInfo);
            }
        }
    }

    private void createElementInEgeria(String schemaGUID, RegisteredModelInfo modelInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ucModelGUID;
        String parentLinkTypeName = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName;
        boolean parentAtEnd1 = false;
        if (this.templateGUID != null) {
            ucModelGUID = this.openMetadataAccess.createMetadataElementFromTemplate(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), schemaGUID, false, null, null, this.templateGUID, null, this.getPlaceholderProperties(modelInfo), schemaGUID, parentLinkTypeName, null, false);
        } else {
            String qualifiedName = super.getQualifiedName(modelInfo.getFull_name());
            ucModelGUID = this.openMetadataAccess.createMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, schemaGUID, false, null, null, this.getElementProperties(qualifiedName, modelInfo), schemaGUID, parentLinkTypeName, null, false);
            HashMap<String, String> facetProperties = new HashMap<String, String>();
            facetProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), modelInfo.getStorage_location());
            super.addPropertyFacet(ucModelGUID, qualifiedName, modelInfo, facetProperties);
        }
        this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, ucModelGUID, this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(modelInfo, modelInfo.getSchema_name(), UnityCatalogPlaceholderProperty.MODEL_NAME.getName(), modelInfo.getId(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.ucFullNameToEgeriaGUID.put(modelInfo.getFull_name(), ucModelGUID);
    }

    private void updateElementInEgeria(RegisteredModelInfo modelInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaModelGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, egeriaModelGUID, false, this.getElementProperties(modelInfo));
        this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, egeriaModelGUID, this.entityTypeName, modelInfo.getId());
    }

    private void createElementInThirdParty(String schemaName, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        RegisteredModelInfo modelInfo = this.ucConnector.createRegisteredModel(super.getUCNameFromMember(memberElement), this.catalogName, schemaName, super.getUCCommentFomMember(memberElement), super.getUCStorageLocationFromMember(memberElement));
        if (memberElement.getExternalIdentifier() == null) {
            this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(modelInfo, modelInfo.getSchema_name(), UnityCatalogPlaceholderProperty.MODEL_NAME.getName(), modelInfo.getId(), PermittedSynchronization.TO_THIRD_PARTY));
        } else {
            this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), modelInfo.getId());
        }
    }

    private void updateElementInThirdParty(RegisteredModelInfo modelInfo, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.VOLUME_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), modelInfo.getFull_name(), this.ucServerEndpoint));
        this.context.confirmSynchronization(this.catalogGUID, this.catalogName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), modelInfo.getId());
    }

    private void deleteElementInThirdParty(RegisteredModelInfo modelInfo) throws PropertyServerException {
        String methodName = "deleteElementInThirdParty";
        this.auditLog.logMessage("deleteElementInThirdParty", UCAuditCode.UC_ELEMENT_DELETE.getMessageDefinition(this.connectorName, modelInfo.getFull_name(), this.ucServerEndpoint));
        this.ucConnector.deleteRegisteredModel(modelInfo.getFull_name());
    }

    private Map<String, String> getPlaceholderProperties(RegisteredModelInfo info) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), info.getCatalog_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), info.getSchema_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.MODEL_NAME.getName(), info.getName());
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), info.getComment());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), null);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), info.getStorage_location());
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(RegisteredModelInfo info) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, info.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, info.getFull_name());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, info.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, RegisteredModelInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }
}

