/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.ColumnInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.MetadataCollectionIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogInsideCatalogSyncTables
extends OSSUnityCatalogInsideCatalogSyncBase {
    private final String entityTypeName;
    private String templateGUID;

    public OSSUnityCatalogInsideCatalogSyncTables(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogGUID, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, catalogGUID, catalogName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_TABLE, templates, configurationProperties, excludeNames, includeNames, auditLog);
        this.entityTypeName = OpenMetadataType.VIRTUAL_RELATIONAL_TABLE.typeName;
        this.templateGUID = null;
        if (templates != null) {
            this.templateGUID = templates.get(this.deployedImplementationType.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaTables";
        MetadataCollectionIterator tableIterator = new MetadataCollectionIterator(this.catalogGUID, this.catalogQualifiedName, this.catalogGUID, this.catalogQualifiedName, this.catalogName, this.connectorName, this.entityTypeName, this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (tableIterator.moreToReceive()) {
            MemberElement nextElement = tableIterator.getNextMember();
            if (nextElement == null) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeriaTables");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            TableInfo tableInfo = null;
            String tableName = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.RESOURCE_NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeriaTables");
            if (!this.context.elementShouldBeCatalogued(tableName, this.excludeNames, this.includeNames)) continue;
            try {
                tableInfo = this.ucConnector.getTable(tableName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MemberAction memberAction = MemberAction.NO_ACTION;
            if (tableInfo == null) {
                memberAction = nextElement.getMemberAction(null, null);
            } else if (this.noMismatchInExternalIdentifier(tableInfo.getTable_id(), nextElement)) {
                memberAction = nextElement.getMemberAction(this.getDateFromLong(tableInfo.getCreated_at()), this.getDateFromLong(tableInfo.getUpdated_at()));
            }
            this.takeAction(this.context.getAnchorGUID(nextElement.getElement()), super.getUCSchemaFromMember(nextElement), memberAction, nextElement, tableInfo);
        }
        return tableIterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaInfo> ucSchemaList = this.ucConnector.listSchemas(this.catalogName);
        if (ucSchemaList != null) {
            for (SchemaInfo schemaInfo : ucSchemaList) {
                List<TableInfo> ucTableList;
                String schemaGUID;
                if (schemaInfo == null || (schemaGUID = (String)this.ucFullNameToEgeriaGUID.get(schemaInfo.getFull_name())) == null || (ucTableList = this.ucConnector.listTables(this.catalogName, schemaInfo.getName())) == null) continue;
                for (TableInfo tableInfo : ucTableList) {
                    if (tableInfo == null || this.ucFullNameToEgeriaGUID.get(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName()) != null) continue;
                    String ucTableQualifiedName = this.getQualifiedName(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName());
                    MemberElement memberElement = iterator.getMemberByQualifiedName(ucTableQualifiedName);
                    MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(tableInfo.getCreated_at()), this.getDateFromLong(tableInfo.getUpdated_at()));
                    if (!this.noMismatchInExternalIdentifier(tableInfo.getTable_id(), memberElement)) continue;
                    this.takeAction(schemaGUID, tableInfo.getSchema_name(), memberAction, memberElement, tableInfo);
                }
            }
        }
    }

    private void takeAction(String schemaGUID, String schemaName, MemberAction memberAction, MemberElement memberElement, TableInfo tableInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(schemaGUID, tableInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(tableInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(schemaName, memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(tableInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(tableInfo);
            }
        }
    }

    private void createElementInEgeria(String schemaGUID, TableInfo tableInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ucTableGUID;
        String parentLinkTypeName = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName;
        boolean parentAtEnd1 = false;
        if (this.templateGUID != null) {
            ucTableGUID = this.openMetadataAccess.createMetadataElementFromTemplate(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), schemaGUID, false, null, null, this.templateGUID, null, this.getPlaceholderProperties(tableInfo), schemaGUID, parentLinkTypeName, null, false);
        } else {
            String qualifiedName = super.getQualifiedName(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName());
            ucTableGUID = this.openMetadataAccess.createMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, schemaGUID, false, null, null, this.getElementProperties(qualifiedName, tableInfo), schemaGUID, parentLinkTypeName, null, false);
            HashMap<String, String> facetProperties = new HashMap<String, String>();
            facetProperties.put(UnityCatalogPlaceholderProperty.TABLE_TYPE.getName(), tableInfo.getTable_type());
            facetProperties.put(UnityCatalogPlaceholderProperty.DATA_SOURCE_FORMAT.getName(), tableInfo.getData_source_format());
            facetProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), tableInfo.getStorage_location());
            super.addPropertyFacet(ucTableGUID, qualifiedName, tableInfo, facetProperties);
        }
        this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, ucTableGUID, this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(tableInfo, tableInfo.getSchema_name(), UnityCatalogPlaceholderProperty.TABLE_NAME.getName(), tableInfo.getTable_id(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.createSchemaAttributesForUCTable(ucTableGUID, tableInfo);
        this.ucFullNameToEgeriaGUID.put(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), ucTableGUID);
    }

    private void updateElementInEgeria(TableInfo tableInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaTableGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, egeriaTableGUID, false, this.getElementProperties(tableInfo));
        this.updateSchemaAttributesForUCTable(memberElement, tableInfo);
        this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, egeriaTableGUID, this.entityTypeName, tableInfo.getTable_id());
    }

    private void createElementInThirdParty(String schemaName, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        TableInfo tableInfo = this.ucConnector.createTable(super.getUCNameFromMember(memberElement), this.catalogName, schemaName, super.getUCCommentFomMember(memberElement), this.getUCTableTypeFromMember(memberElement), this.getUCDataSourceFormatFromMember(memberElement), this.getUCColumnsForTable(memberElement), super.getUCStorageLocationFromMember(memberElement));
        if (memberElement.getExternalIdentifier() == null) {
            this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(tableInfo, tableInfo.getSchema_name(), UnityCatalogPlaceholderProperty.TABLE_NAME.getName(), tableInfo.getTable_id(), PermittedSynchronization.TO_THIRD_PARTY));
        } else {
            this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), tableInfo.getTable_id());
        }
    }

    private String getUCTableTypeFromMember(MemberElement memberElement) {
        Map vendorProperties = memberElement.getVendorProperties("Unity Catalog (UC)");
        if (vendorProperties != null) {
            return (String)vendorProperties.get(UnityCatalogPlaceholderProperty.TABLE_TYPE.getName());
        }
        return null;
    }

    private String getUCDataSourceFormatFromMember(MemberElement memberElement) {
        String methodName = "getUCDataSourceFormatFromMember";
        return this.propertyHelper.getStringPropertyFromClassification(memberElement.getElement(), OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, OpenMetadataProperty.ENCODING.name, "getUCDataSourceFormatFromMember");
    }

    private void updateElementInThirdParty(TableInfo tableInfo, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.TABLE_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), this.ucServerEndpoint));
        this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), tableInfo.getTable_id());
    }

    private void deleteElementInThirdParty(TableInfo tableInfo) throws PropertyServerException {
        String methodName = "deleteElementInThirdParty";
        this.auditLog.logMessage("deleteElementInThirdParty", UCAuditCode.UC_ELEMENT_DELETE.getMessageDefinition(this.connectorName, tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), this.ucServerEndpoint));
        this.ucConnector.deleteTable(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName());
    }

    private Map<String, String> getPlaceholderProperties(TableInfo info) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), info.getCatalog_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), info.getSchema_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.TABLE_NAME.getName(), info.getName());
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), info.getComment());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), null);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), info.getStorage_location());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.TABLE_TYPE.getName(), info.getTable_type());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.DATA_SOURCE_FORMAT.getName(), info.getData_source_format());
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(TableInfo tableInfo) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, tableInfo.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, tableInfo.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, TableInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }

    private List<ColumnInfo> getUCColumnsForTable(MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (memberElement.getRootSchemaType() != null) {
            ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
            int startFrom = 0;
            RelatedMetadataElementList schemaAttributes = this.openMetadataAccess.getRelatedMetadataElements(memberElement.getRootSchemaType().getElement().getElementGUID(), 1, "AttributeForSchema", startFrom, this.context.getMaxPageSize());
            while (schemaAttributes != null && schemaAttributes.getElementList() != null) {
                for (RelatedMetadataElement schemaAttribute : schemaAttributes.getElementList()) {
                    if (schemaAttribute == null) continue;
                    columnInfoList.add(this.getUCColumnFromSchemaAttribute(schemaAttribute));
                }
                schemaAttributes = this.openMetadataAccess.getRelatedMetadataElements(memberElement.getRootSchemaType().getElement().getElementGUID(), 1, "AttributeForSchema", startFrom += this.context.getMaxPageSize(), this.context.getMaxPageSize());
            }
            if (!columnInfoList.isEmpty()) {
                return columnInfoList;
            }
        }
        return null;
    }

    private ColumnInfo getUCColumnFromSchemaAttribute(RelatedMetadataElement schemaAttribute) {
        return null;
    }

    private void createSchemaAttributesForUCTable(String tableGUID, TableInfo tableInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createSchemaAttributesForUCTable";
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, super.getQualifiedName(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName()) + "_rootSchemaType");
        this.openMetadataAccess.createMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, OpenMetadataType.TABULAR_SCHEMA_TYPE.typeName, ElementStatus.ACTIVE, null, tableGUID, false, null, null, properties, tableGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, true);
        this.auditLog.logMessage("createSchemaAttributesForUCTable", UCAuditCode.MISSING_METHOD.getMessageDefinition(this.connectorName, "createSchemaAttributesForUCTable", tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), this.ucServerEndpoint));
    }

    private void updateSchemaAttributesForUCTable(MemberElement memberElement, TableInfo tableInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttributesForUCTable";
        this.auditLog.logMessage("updateSchemaAttributesForUCTable", UCAuditCode.MISSING_METHOD.getMessageDefinition(this.connectorName, "updateSchemaAttributesForUCTable", tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), this.ucServerEndpoint));
    }
}

