/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogMetric;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyDatabaseAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyResourceManagerAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum UnityCatalogAnnotationType implements AnnotationType
{
    RESOURCE_INVENTORY("Log of Unity Catalog (UC) Resources", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Log file of resource name, description and deployed implementation type.", "If resource are missing, check the security permissions of the survey service's userId.", AnalysisStep.PRODUCE_INVENTORY.getName(), UnityCatalogAnnotationType.getProfilePropertiesPropertyName(), null),
    CATALOG_LIST("Capture List of Unity Catalog (UC) Catalogs", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible catalogs in a Unity Catalog (UC) server.", "If catalogs are missing, check the security permissions of the survey service's userId.", AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName(), UnityCatalogAnnotationType.getProfilePropertiesPropertyName(), null),
    CATALOG_TABLE_SIZES("Capture Unity Catalog (UC) Catalog Table Sizes", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the sizes of the visible tables in a Unity Catalog (UC) catalog.", "Tables listed include their catalog name and schema name.  If tables are missing, check the security permissions of the survey service's userId.", AnalysisStep.PROFILE_DATA.getName(), null, null),
    SCHEMA_TABLE_SIZES("Capture Table Sizes for a Database Schema", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the sizes of the visible tables in a Unity Catalog (UC) schema.", "Tables listed include their catalog name and schema name.  If tables are missing, check the security permissions of the survey service's userId.", AnalysisStep.PROFILE_DATA.getName(), null, null),
    SERVER_METRICS("Capture Unity Catalog (UC) Server Metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a database.", "This annotation retrieves statistics about a Unity Catalog (UC) server and its contents.", AnalysisStep.MEASURE_RESOURCE.getName(), null, UnityCatalogMetric.getServerMetrics()),
    CATALOG_METRICS("Capture Unity Catalog (UC) Catalog Metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a Unity Catalog (UC) catalog.", "This annotation retrieves statistics about a catalog and its schemas, tables, volumes and functions.", AnalysisStep.MEASURE_RESOURCE.getName(), null, UnityCatalogMetric.getCatalogMetrics()),
    SCHEMA_METRICS("Capture Unity Catalog (UC) Schema Metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about the tables in a Unity Catalog (UC) schema.", "This annotation retrieves statistics about individual tables and columns, and aggregates them into a summary for the schema.", AnalysisStep.MEASURE_RESOURCE.getName(), null, UnityCatalogMetric.getSchemaMetrics()),
    TABLE_METRICS("Capture Unity Catalog (UC) Table Metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a Unity Catalog (UC) table.", "This annotation retrieves statistics about individual columns and aggregates them into a summary for the table.", AnalysisStep.MEASURE_RESOURCE.getName(), null, UnityCatalogMetric.getTableMetrics()),
    COLUMN_METRICS("Capture Unity Catalog (UC) Column Metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a Unity Catalog (UC) column.", "This annotation retrieves statistics about an individual column.", AnalysisStep.MEASURE_RESOURCE.getName(), null, UnityCatalogMetric.getColumnMetrics());

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final String analysisStepName;
    public final List<String> profilePropertyNames;
    public final List<SurveyMetric> metrics;

    private UnityCatalogAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, String analysisStepName, List<String> profilePropertyNames, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.analysisStepName = analysisStepName;
        this.profilePropertyNames = profilePropertyNames;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getServerAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(RESOURCE_INVENTORY.getAnnotationTypeType());
        annotationTypeTypes.add(SERVER_METRICS.getAnnotationTypeType());
        annotationTypeTypes.add(CATALOG_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.SCHEMA_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.TABLE_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.COLUMN_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.FUNCTION_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.VOLUME_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.MODEL_LIST.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    public static List<AnnotationTypeType> getCatalogAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(RESOURCE_INVENTORY.getAnnotationTypeType());
        annotationTypeTypes.add(CATALOG_METRICS.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.SCHEMA_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.TABLE_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.COLUMN_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.FUNCTION_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.VOLUME_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.MODEL_LIST.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    public static List<AnnotationTypeType> getSchemaAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(RESOURCE_INVENTORY.getAnnotationTypeType());
        annotationTypeTypes.add(SCHEMA_METRICS.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.TABLE_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyDatabaseAnnotationType.COLUMN_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.FUNCTION_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.VOLUME_LIST.getAnnotationTypeType());
        annotationTypeTypes.add(SurveyResourceManagerAnnotationType.MODEL_LIST.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    private static List<String> getProfilePropertiesPropertyName() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
        return propertyNames;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        return this.analysisStepName;
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getExpression() {
        return null;
    }

    public List<String> getProfilePropertyNames() {
        return this.profilePropertyNames;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(this.analysisStepName);
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric relationalDatabaseMetric : this.metrics) {
                metricsMap.put(relationalDatabaseMetric.getDisplayName(), relationalDatabaseMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

