/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum UnityCatalogDeployedImplementationType implements DeployedImplementationTypeDefinition
{
    OSS_UC_VOLUME("Unity Catalog Volume", (DeployedImplementationTypeDefinition)DeployedImplementationType.DATA_FOLDER, OpenMetadataType.DATA_FOLDER.typeName, null, "A collection of related data files within the Unity Catalog (UC) 'catalog of catalogs'.", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_REGISTERED_MODEL("Unity Catalog Registered Model", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_COMPONENT, OpenMetadataType.DEPLOYED_ANALYTICS_MODEL.typeName, null, "An analytics model deployed to Unity Catalog (UC).", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_REGISTERED_MODEL_VERSION("Unity Catalog Registered Model Version", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_COMPONENT, OpenMetadataType.ANALYTICS_MODEL_RUN.typeName, null, "A version of an analytics model deployed to Unity Catalog (UC).", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_FUNCTION("Unity Catalog Function", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_COMPONENT, OpenMetadataType.DEPLOYED_API.typeName, null, "A function found in Unity Catalog (UC) that is working with data.", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_TABLE("Unity Catalog Table", (DeployedImplementationTypeDefinition)DeployedImplementationType.DATA_ASSET, OpenMetadataType.VIRTUAL_RELATIONAL_TABLE.typeName, null, "A relational table within the Unity Catalog (UC) 'catalog of catalogs'.", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_SCHEMA("Unity Catalog Schema", (DeployedImplementationTypeDefinition)DeployedImplementationType.JDBC_RELATIONAL_DATABASE_SCHEMA, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, null, "A schema that organizes data assets for an operational data platform catalog within the Unity Catalog (UC) 'catalog of catalogs'.", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UC_CATALOG("Unity Catalog Catalog", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_CAPABILITY, OpenMetadataType.DATA_ACCESS_MANAGER.typeName, null, "An operational data platform catalog within the Unity Catalog (UC) 'catalog of catalogs'.", "https://github.com/unitycatalog/unitycatalog"),
    OSS_UNITY_CATALOG_SERVER("Unity Catalog Server", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName, "The OSS Unity Catalog (UC) Server is an operational data platform 'catalog of catalogs' that supports controlled access to data managed through a related data platforms.", "https://github.com/unitycatalog/unitycatalog"),
    DB_UNITY_CATALOG_SERVER("Databricks Unity Catalog Server", OSS_UNITY_CATALOG_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName, "The Databricks Unity Catalog (UC) Server is an operational data platform 'catalog of catalogs' that supports controlled access to data managed through a related data platforms.", "https://github.com/unitycatalog/unitycatalog");

    private final String deployedImplementationType;
    private final DeployedImplementationTypeDefinition isATypeOf;
    private final String associatedTypeName;
    private final String associatedClassification;
    private final String description;
    private final String wikiLink;

    public static DeployedImplementationTypeDefinition getDefinitionFromDeployedImplementationType(String deployedImplementationType) {
        if (deployedImplementationType != null) {
            for (UnityCatalogDeployedImplementationType definition : UnityCatalogDeployedImplementationType.values()) {
                if (!definition.getDeployedImplementationType().equals(deployedImplementationType)) continue;
                return definition;
            }
        }
        return null;
    }

    private UnityCatalogDeployedImplementationType(String deployedImplementationType, DeployedImplementationTypeDefinition isATypeOf, String associatedTypeName, String associatedClassification, String description, String wikiLink) {
        this.deployedImplementationType = deployedImplementationType;
        this.isATypeOf = isATypeOf;
        this.associatedTypeName = associatedTypeName;
        this.associatedClassification = associatedClassification;
        this.description = description;
        this.wikiLink = wikiLink;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getIsATypeOf() {
        return this.isATypeOf;
    }

    public String getAssociatedTypeName() {
        return this.associatedTypeName;
    }

    public String getAssociatedClassification() {
        return this.associatedClassification;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)this.deployedImplementationType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String toString() {
        return "DeployedImplementationType{" + this.deployedImplementationType + "}";
    }
}

