/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;

public enum UnityCatalogTarget {
    UNITY_CATALOG_SERVER_TARGET("unityCatalogServer", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDescription(), UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName(), UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDeployedImplementationType(), null),
    UNITY_CATALOG_CATALOG_TARGET("unityCatalogCatalog", UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDescription(), UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getAssociatedTypeName(), UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType(), null),
    UNITY_CATALOG_CONNECTOR_TARGET("unityCatalogConnector", DeployedImplementationType.CATALOG_INTEGRATION_CONNECTOR.getDescription(), DeployedImplementationType.CATALOG_INTEGRATION_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.CATALOG_INTEGRATION_CONNECTOR.getDeployedImplementationType(), null);

    private final String name;
    public final String description;
    private final String typeName;
    private final String deployedImplementationType;
    private final Map<String, String> otherPropertyValues;

    private UnityCatalogTarget(String name, String description, String typeName, String deployedImplementationType, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<CatalogTargetType> getServerCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        catalogTargetTypes.add(UNITY_CATALOG_SERVER_TARGET.getCatalogTargetType());
        catalogTargetTypes.add(UNITY_CATALOG_CONNECTOR_TARGET.getCatalogTargetType());
        return catalogTargetTypes;
    }

    public static List<CatalogTargetType> getUCCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        catalogTargetTypes.add(UNITY_CATALOG_CATALOG_TARGET.getCatalogTargetType());
        return catalogTargetTypes;
    }

    public CatalogTargetType getCatalogTargetType() {
        CatalogTargetType catalogTargetType = new CatalogTargetType();
        catalogTargetType.setName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setDeployedImplementationType(this.deployedImplementationType);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public static List<ActionTargetType> getSchemaActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(UNITY_CATALOG_SERVER_TARGET.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getCatalogActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(UNITY_CATALOG_SERVER_TARGET.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getServerActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(UNITY_CATALOG_SERVER_TARGET.getActionTargetType());
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String toString() {
        return "TargetEnum{catalogTargetName='" + this.name + "'}";
    }
}

