/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

public enum UnityCatalogTemplateType implements TemplateDefinition
{
    OSS_UC_SERVER_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDeployedImplementationType(), "A SoftwareServer asset with connection and REST API Manager software capability representing a Unity Catalog (UC) Server.", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName(), false, "dcca9788-b30f-4007-b1ac-ec634aff6879", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER, UnityCatalogPlaceholderProperty.getServerPlaceholderPropertyTypes(), null),
    DB_UC_SERVER_TEMPLATE(UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getDeployedImplementationType(), "A SoftwareServer asset with connection and REST API Manager software capability representing a Unity Catalog (UC) Server running in a Databricks managed platform.", UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getAssociatedTypeName(), false, "3f7f62f6-4abc-424e-9f92-523306e7d5d5", UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER, UnityCatalogPlaceholderProperty.getServerPlaceholderPropertyTypes(), null),
    OSS_UC_CATALOG_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType(), "Create a " + UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getAssociatedTypeName() + " SoftwareCapability.", UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getAssociatedTypeName(), false, "5ee006aa-a6d6-411b-9b8d-5f720c079cae", UnityCatalogDeployedImplementationType.OSS_UC_CATALOG, UnityCatalogPlaceholderProperty.getCatalogPlaceholderPropertyTypes(), null),
    OSS_UC_SCHEMA_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType(), "Create a DeployedDatabaseSchema to represent a schema from the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getAssociatedTypeName(), false, "5bf92b0f-3970-41ea-b0a3-aacfbf6fd92e", UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA, UnityCatalogPlaceholderProperty.getSchemaPlaceholderPropertyTypes(), null),
    OSS_UC_VOLUME_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType(), "Create a DataFolder asset to represent a volume from the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getAssociatedTypeName(), false, "92d2d2dc-0798-41f0-9512-b10548d312b7", UnityCatalogDeployedImplementationType.OSS_UC_VOLUME, UnityCatalogPlaceholderProperty.getVolumePlaceholderPropertyTypes(), null),
    OSS_UC_TABLE_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType(), "Create a VirtualTableAsset asset to represent a table from the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getAssociatedTypeName(), false, "6cc1e5f5-4c1e-4290-a80e-e06643ffb13d", UnityCatalogDeployedImplementationType.OSS_UC_TABLE, UnityCatalogPlaceholderProperty.getTablePlaceholderPropertyTypes(), null),
    OSS_UC_FUNCTION_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType(), "Create a DeployedSoftwareComponent asset to represent a function from the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getAssociatedTypeName(), false, "a490ba65-6104-4213-9be9-524e16fed8aa", UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION, UnityCatalogPlaceholderProperty.getFunctionPlaceholderPropertyTypes(), null),
    OSS_UC_REGISTERED_MODEL_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL.getDeployedImplementationType(), "Create a DeployedAnalyticsModel asset to represent an analytics model deployed to the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL.getAssociatedTypeName(), false, "0d762ec5-c1f5-4364-aa64-e7e00d27f837", UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL, UnityCatalogPlaceholderProperty.getRegisteredModelPlaceholderPropertyTypes(), null),
    OSS_UC_MODEL_VERSION_TEMPLATE(UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL_VERSION.getDeployedImplementationType(), "Create an AnalyticsModelRun asset to represent a version of an analytics model deployed to the Unity Catalog (UC).", UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL_VERSION.getAssociatedTypeName(), false, "1364bfe7-8295-4e99-9243-8840aeac4cf1", UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL_VERSION, UnityCatalogPlaceholderProperty.getModelVersionPlaceholderPropertyTypes(), null);

    private final String templateName;
    private final String templateDescription;
    private final String typeName;
    private final boolean required;
    private final String defaultTemplateGUID;
    private final Map<String, String> otherPropertyValues;
    private final UnityCatalogDeployedImplementationType deployedImplementationType;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;

    private UnityCatalogTemplateType(String templateName, String templateDescription, String typeName, boolean required, String defaultTemplateGUID, UnityCatalogDeployedImplementationType deployedImplementationType, List<PlaceholderPropertyType> placeholderPropertyTypes, Map<String, String> otherPropertyValues) {
        this.templateName = templateName;
        this.templateDescription = templateDescription;
        this.typeName = typeName;
        this.required = required;
        this.defaultTemplateGUID = defaultTemplateGUID;
        this.deployedImplementationType = deployedImplementationType;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getTemplateGUID() {
        return this.defaultTemplateGUID;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String getElementVersionIdentifier() {
        return PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder();
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getRequired() {
        return this.required;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<TemplateType> getTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        for (UnityCatalogTemplateType templateTypeEnum : UnityCatalogTemplateType.values()) {
            templateTypes.add(templateTypeEnum.getTemplateType());
        }
        return templateTypes;
    }

    public static List<TemplateType> getInsideCatalogTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        templateTypes.add(OSS_UC_CATALOG_TEMPLATE.getTemplateType());
        templateTypes.add(OSS_UC_SCHEMA_TEMPLATE.getTemplateType());
        templateTypes.add(OSS_UC_VOLUME_TEMPLATE.getTemplateType());
        templateTypes.add(OSS_UC_TABLE_TEMPLATE.getTemplateType());
        templateTypes.add(OSS_UC_FUNCTION_TEMPLATE.getTemplateType());
        return templateTypes;
    }

    public TemplateType getTemplateType() {
        TemplateType templateType = new TemplateType();
        templateType.setTemplateName(this.templateName);
        templateType.setTypeName(this.typeName);
        templateType.setTemplateDescription(this.templateDescription);
        templateType.setRequired(this.required);
        templateType.setDefaultTemplateGUID(this.defaultTemplateGUID);
        templateType.setOtherPropertyValues(this.otherPropertyValues);
        return templateType;
    }

    public String toString() {
        return "TemplateType{templateName='" + this.templateName + "'}";
    }
}

