/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.provision;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogTemplateType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.provision.ProvisionUnityCatalogGuard;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.provision.ProvisionUnityCatalogRequestParameter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ProvisionUnityCatalogGovernanceActionConnector
extends ProvisioningGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CompletionStatus completionStatus;
            AuditLogMessageDefinition messageDefinition;
            ArrayList<String> outputGuards = new ArrayList<String>();
            ArrayList<NewActionTarget> outputActionTargets = new ArrayList<NewActionTarget>();
            String deployedImplementationType = super.getProperty(ProvisionUnityCatalogRequestParameter.TECHNOLOGY_TYPE.getName(), null);
            if (deployedImplementationType == null) {
                messageDefinition = UCAuditCode.NO_TECHNOLOGY_TYPE.getMessageDefinition(this.governanceServiceName);
                outputGuards.add(ProvisionUnityCatalogGuard.NO_TECHNOLOGY_TYPE.getName());
                completionStatus = ProvisionUnityCatalogGuard.NO_TECHNOLOGY_TYPE.getCompletionStatus();
            } else {
                String templateGUID = this.getTemplateGUID(deployedImplementationType);
                if (templateGUID == null) {
                    messageDefinition = UCAuditCode.INVALID_TECHNOLOGY_TYPE.getMessageDefinition(this.governanceServiceName, deployedImplementationType);
                    outputGuards.add(ProvisionUnityCatalogGuard.INVALID_TECHNOLOGY_TYPE.getName());
                    completionStatus = ProvisionUnityCatalogGuard.INVALID_TECHNOLOGY_TYPE.getCompletionStatus();
                } else {
                    List<String> missingPlaceholderVariables = this.getMissingPlaceholderVariables(deployedImplementationType);
                    if (missingPlaceholderVariables != null) {
                        messageDefinition = UCAuditCode.MISSING_PLACEHOLDER_VALUES.getMessageDefinition(this.governanceServiceName, deployedImplementationType, missingPlaceholderVariables.toString());
                        outputGuards.add(ProvisionUnityCatalogGuard.MISSING_PLACEHOLDER_VALUES.getName());
                        completionStatus = ProvisionUnityCatalogGuard.MISSING_PLACEHOLDER_VALUES.getCompletionStatus();
                    } else {
                        String elementGUID = this.createNewElement(deployedImplementationType, templateGUID);
                        OpenMetadataElement serverElement = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(elementGUID);
                        messageDefinition = UCAuditCode.NEW_ELEMENT_CREATED.getMessageDefinition(this.governanceServiceName, deployedImplementationType, this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.QUALIFIED_NAME.name, serverElement.getElementProperties(), "start"), elementGUID);
                        NewActionTarget newActionTarget = new NewActionTarget();
                        newActionTarget.setActionTargetGUID(elementGUID);
                        newActionTarget.setActionTargetName(ActionTarget.NEW_ASSET.name);
                        outputActionTargets.add(newActionTarget);
                        completionStatus = ProvisionUnityCatalogGuard.SET_UP_COMPLETE.getCompletionStatus();
                        outputGuards.add(ProvisionUnityCatalogGuard.SET_UP_COMPLETE.getName());
                    }
                }
            }
            this.auditLog.logMessage("start", messageDefinition);
            if (outputActionTargets.isEmpty()) {
                outputActionTargets = null;
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, outputActionTargets, messageDefinition);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", error);
        }
    }

    private String getTemplateGUID(String deployedImplementationType) {
        String templateGUID;
        if (UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType().equals(deployedImplementationType)) {
            templateGUID = UnityCatalogTemplateType.OSS_UC_CATALOG_TEMPLATE.getTemplateGUID();
        } else if (UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType().equals(deployedImplementationType)) {
            templateGUID = UnityCatalogTemplateType.OSS_UC_SCHEMA_TEMPLATE.getTemplateGUID();
        } else if (UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType().equals(deployedImplementationType)) {
            templateGUID = UnityCatalogTemplateType.OSS_UC_VOLUME_TEMPLATE.getTemplateGUID();
        } else if (UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType().equals(deployedImplementationType)) {
            templateGUID = UnityCatalogTemplateType.OSS_UC_FUNCTION_TEMPLATE.getTemplateGUID();
        } else if (UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType().equals(deployedImplementationType)) {
            templateGUID = UnityCatalogTemplateType.OSS_UC_TABLE_TEMPLATE.getTemplateGUID();
        } else {
            return null;
        }
        return super.getProperty(ProvisionUnityCatalogRequestParameter.TEMPLATE_GUID.getName(), templateGUID);
    }

    private String createNewElement(String deployedImplementationType, String templateGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.createNewCatalog(templateGUID);
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.createNewSchema(templateGUID);
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.createNewSchemaResource(templateGUID, UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getAssociatedTypeName());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.createNewSchemaResource(templateGUID, UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getAssociatedTypeName());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.createNewSchemaResource(templateGUID, UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getAssociatedTypeName());
        }
        return null;
    }

    private String createNewCatalog(String templateGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String serverGUID = this.getServerAnchorGUID(this.getProperty(UnityCatalogPlaceholderProperty.SERVER_QUALIFIED_NAME.getName(), null));
        return this.governanceContext.getOpenMetadataStore().getMetadataElementFromTemplate(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getAssociatedTypeName(), serverGUID, false, null, null, null, templateGUID, null, this.governanceContext.getRequestParameters(), serverGUID, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), OperationalStatus.ENABLED.getName()), true);
    }

    private String createNewSchema(String templateGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String serverNetworkAddress = super.getProperty(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), null);
        String catalogName = super.getProperty(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), null);
        String catalogGUID = this.getCatalogAnchorGUID(serverNetworkAddress, catalogName);
        String catalogQualifiedName = this.getCatalogQualifiedName(catalogGUID);
        return this.governanceContext.getOpenMetadataStore().getMetadataElementFromTemplate(catalogGUID, catalogQualifiedName, UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getAssociatedTypeName(), catalogGUID, false, null, null, null, templateGUID, null, this.governanceContext.getRequestParameters(), catalogGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName()), true);
    }

    private String createNewSchemaResource(String templateGUID, String openMetadataTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String rootSchemaTypeGUID;
        String serverNetworkAddress = super.getProperty(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), null);
        String catalogName = super.getProperty(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), null);
        String catalogGUID = this.getCatalogAnchorGUID(serverNetworkAddress, catalogName);
        String catalogQualifiedName = this.getCatalogQualifiedName(catalogGUID);
        String schemaGUID = this.getSchemaParentGUID(serverNetworkAddress, catalogName, super.getProperty(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), null));
        String elementGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementFromTemplate(catalogGUID, catalogQualifiedName, openMetadataTypeName, schemaGUID, false, schemaGUID, null, null, templateGUID, null, this.governanceContext.getRequestParameters(), schemaGUID, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName, null, true);
        String rootSchemaTypeQualifiedName = this.getProperty(PlaceholderProperty.ROOT_SCHEMA_TYPE_QUALIFIED_NAME.getName(), null);
        if (rootSchemaTypeQualifiedName != null && (rootSchemaTypeGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(rootSchemaTypeQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name)) != null) {
            this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(catalogGUID, catalogQualifiedName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, elementGUID, rootSchemaTypeGUID, null, null, null);
        }
        return elementGUID;
    }

    private List<String> getMissingPlaceholderVariables(String deployedImplementationType) throws ConnectorCheckedException {
        String methodName = "getMissingPlaceholderVariables";
        if (UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.getMissingPlaceholderVariables(UnityCatalogPlaceholderProperty.getCatalogPlaceholderPropertyTypes());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.getMissingPlaceholderVariables(UnityCatalogPlaceholderProperty.getSchemaPlaceholderPropertyTypes());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.getMissingPlaceholderVariables(UnityCatalogPlaceholderProperty.getVolumePlaceholderPropertyTypes());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.getMissingPlaceholderVariables(UnityCatalogPlaceholderProperty.getFunctionPlaceholderPropertyTypes());
        }
        if (UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType().equals(deployedImplementationType)) {
            return this.getMissingPlaceholderVariables(UnityCatalogPlaceholderProperty.getTablePlaceholderPropertyTypes());
        }
        throw new ConnectorCheckedException(UCErrorCode.LOGIC_ERROR.getMessageDefinition(this.governanceServiceName, "getMissingPlaceholderVariables", deployedImplementationType), ((Object)((Object)this)).getClass().getName(), "getMissingPlaceholderVariables");
    }

    private List<String> getMissingPlaceholderVariables(List<PlaceholderPropertyType> expectedPlaceholders) {
        ArrayList<String> missingPlaceholderValues = new ArrayList<String>();
        for (PlaceholderPropertyType placeholderPropertyType : expectedPlaceholders) {
            if (this.governanceContext.getRequestParameters().containsKey(placeholderPropertyType.getName())) continue;
            missingPlaceholderValues.add(placeholderPropertyType.getName());
        }
        if (missingPlaceholderValues.isEmpty()) {
            return null;
        }
        return missingPlaceholderValues;
    }

    private String getServerAnchorGUID(String serverQualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(serverQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
    }

    private String getCatalogAnchorGUID(String serverNetworkAddress, String catalogName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType() + "::" + serverNetworkAddress + "::" + catalogName, OpenMetadataProperty.QUALIFIED_NAME.name);
    }

    private String getSchemaParentGUID(String serverNetworkAddress, String catalogName, String schemaName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType() + "::" + serverNetworkAddress + "::" + catalogName + "." + schemaName, OpenMetadataProperty.QUALIFIED_NAME.name);
    }

    private String getCatalogQualifiedName(String catalogGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCatalogQualifiedName";
        OpenMetadataElement metadataElement = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(catalogGUID);
        return this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.QUALIFIED_NAME.name, metadataElement.getElementProperties(), "getCatalogQualifiedName");
    }
}

