/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.survey;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogAnnotationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogMetric;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.ColumnInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.RegisteredModelInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogServerSurveyBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyDatabaseAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyResourceManagerAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDataManagerMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;

public class OSSUnityCatalogInsideSchemaSurveyService
extends OSSUnityCatalogServerSurveyBase {
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.setFinalAnalysisStep();
        try {
            this.connector = this.performCheckAssetAnalysisStep(OSSUnityCatalogResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            OSSUnityCatalogResourceConnector ucConnector = (OSSUnityCatalogResourceConnector)this.connector;
            String catalogName = this.getCatalogName();
            String schemaName = this.getSchemaName();
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> functionList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> tableList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> columnList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> volumeList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> modelList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            long functionCount = 0L;
            long tableCount = 0L;
            long columnCount = 0L;
            long volumeCount = 0L;
            long modelCount = 0L;
            if (catalogName != null && schemaName != null) {
                List<FunctionInfo> list;
                List<RegisteredModelInfo> list2;
                List<TableInfo> tableInfos;
                List<VolumeInfo> volumeInfos = ucConnector.listVolumes(catalogName, schemaName);
                if (volumeInfos != null) {
                    for (VolumeInfo volumeInfo : volumeInfos) {
                        if (volumeInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = volumeInfo.getComment();
                        resourceProperties.creationDate = new Date(volumeInfo.getCreated_at());
                        resourceProperties.createdBy = volumeInfo.getCreated_by();
                        if (volumeInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(volumeInfo.getUpdated_at());
                        }
                        resourceProperties.lastUpdatedBy = volumeInfo.getUpdated_by();
                        resourceProperties.owner = volumeInfo.getOwner();
                        volumeList.put(volumeInfo.getFull_name(), resourceProperties);
                        ++volumeCount;
                    }
                }
                if ((tableInfos = ucConnector.listTables(catalogName, schemaName)) != null) {
                    for (TableInfo tableInfo : tableInfos) {
                        if (tableInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = tableInfo.getComment();
                        resourceProperties.creationDate = new Date(tableInfo.getCreated_at());
                        resourceProperties.createdBy = tableInfo.getCreated_by();
                        if (tableInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(tableInfo.getUpdated_at());
                        }
                        resourceProperties.lastUpdatedBy = tableInfo.getUpdated_by();
                        resourceProperties.owner = tableInfo.getOwner();
                        tableList.put(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), resourceProperties);
                        ++tableCount;
                        if (tableInfo.getColumns() == null) continue;
                        for (ColumnInfo columnInfo : tableInfo.getColumns()) {
                            OSSUnityCatalogServerSurveyBase.ResourceProperties columnResourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties(resourceProperties);
                            columnResourceProperties.description = columnInfo.getComment();
                            columnList.put(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName() + "." + columnInfo.getName(), columnResourceProperties);
                            ++columnCount;
                        }
                    }
                }
                if ((list2 = ucConnector.listRegisteredModels(catalogName, schemaName)) != null) {
                    for (RegisteredModelInfo registeredModelInfo : list2) {
                        if (registeredModelInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = registeredModelInfo.getComment();
                        resourceProperties.creationDate = new Date(registeredModelInfo.getCreated_at());
                        resourceProperties.createdBy = registeredModelInfo.getCreated_by();
                        if (registeredModelInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(registeredModelInfo.getUpdated_at());
                        }
                        resourceProperties.lastUpdatedBy = registeredModelInfo.getUpdated_by();
                        resourceProperties.owner = registeredModelInfo.getOwner();
                        modelList.put(registeredModelInfo.getFull_name(), resourceProperties);
                        ++modelCount;
                    }
                }
                if ((list = ucConnector.listFunctions(catalogName, schemaName)) != null) {
                    for (FunctionInfo functionInfo : list) {
                        if (functionInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = functionInfo.getComment();
                        resourceProperties.creationDate = new Date(functionInfo.getCreated_at());
                        resourceProperties.createdBy = functionInfo.getCreated_by();
                        if (functionInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(functionInfo.getUpdated_at());
                        }
                        resourceProperties.lastUpdatedBy = functionInfo.getUpdated_by();
                        resourceProperties.owner = functionInfo.getOwner();
                        functionList.put(functionInfo.getFull_name(), resourceProperties);
                        ++functionCount;
                    }
                }
            }
            ResourceMeasureAnnotation resourceMeasureAnnotation = new ResourceMeasureAnnotation();
            this.setUpAnnotation((Annotation)resourceMeasureAnnotation, UnityCatalogAnnotationType.SCHEMA_METRICS);
            RelationalDataManagerMeasurement relationalDataManagerMeasurement = new RelationalDataManagerMeasurement();
            relationalDataManagerMeasurement.setResourceName(catalogName + "." + schemaName);
            relationalDataManagerMeasurement.setTableCount(tableCount);
            relationalDataManagerMeasurement.setColumnCount(columnCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(relationalDataManagerMeasurement));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), Long.toString(functionCount));
            hashMap.put(RelationalDatabaseMetric.TABLE_COUNT.getPropertyName(), Long.toString(tableCount));
            hashMap.put(RelationalDatabaseMetric.COLUMN_COUNT.getPropertyName(), Long.toString(columnCount));
            hashMap.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), Long.toString(volumeCount));
            hashMap.put(UnityCatalogMetric.NO_OF_MODELS.getPropertyName(), Long.toString(modelCount));
            HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
            hashMap2.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), functionCount);
            hashMap2.put(RelationalDatabaseMetric.TABLE_COUNT.getPropertyName(), tableCount);
            hashMap2.put(RelationalDatabaseMetric.COLUMN_COUNT.getPropertyName(), columnCount);
            hashMap2.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), volumeCount);
            hashMap2.put(UnityCatalogMetric.NO_OF_MODELS.getPropertyName(), modelCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(hashMap2));
            resourceMeasureAnnotation.setResourceProperties(hashMap);
            annotationStore.addAnnotation((Annotation)resourceMeasureAnnotation, null);
            if (!this.finalAnalysisStep.equals(AnalysisStep.MEASURE_RESOURCE.getName())) {
                annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
                ResourceProfileAnnotation resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.FUNCTION_LIST, functionList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                ResourceProfileAnnotation resourceProfileAnnotation2 = this.getNameListAnnotation((AnnotationType)SurveyDatabaseAnnotationType.TABLE_LIST, tableList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, null);
                ResourceProfileAnnotation resourceProfileAnnotation3 = this.getNameListAnnotation((AnnotationType)SurveyDatabaseAnnotationType.COLUMN_LIST, columnList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation3, null);
                ResourceProfileAnnotation resourceProfileAnnotation4 = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.VOLUME_LIST, volumeList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation4, null);
                ResourceProfileAnnotation resourceProfileAnnotation5 = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.MODEL_LIST, modelList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation5, null);
                if (!this.finalAnalysisStep.equals(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName())) {
                    annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                    super.writeInventory("unityCatalog-Schema-" + catalogName + "." + schemaName + "-Resources", null, null, functionList, tableList, volumeList);
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }
}

