/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.MetadataCollectionIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogInsideCatalogSyncVolumes
extends OSSUnityCatalogInsideCatalogSyncBase {
    private final String entityTypeName;
    private String templateGUID;

    public OSSUnityCatalogInsideCatalogSyncVolumes(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogGUID, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, catalogGUID, catalogName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_VOLUME, templates, configurationProperties, excludeNames, includeNames, auditLog);
        this.entityTypeName = OpenMetadataType.DATA_FOLDER.typeName;
        this.templateGUID = null;
        if (templates != null) {
            this.templateGUID = templates.get(this.deployedImplementationType.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaVolumes";
        MetadataCollectionIterator volumeIterator = new MetadataCollectionIterator(this.catalogGUID, this.catalogQualifiedName, this.catalogGUID, this.catalogQualifiedName, this.catalogName, this.connectorName, this.entityTypeName, this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (volumeIterator.moreToReceive()) {
            MemberElement nextElement = volumeIterator.getNextMember();
            if (nextElement == null) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeriaVolumes");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            VolumeInfo volumeInfo = null;
            String volumeName = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.RESOURCE_NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeriaVolumes");
            if (!this.context.elementShouldBeCatalogued(volumeName, this.excludeNames, this.includeNames)) continue;
            try {
                volumeInfo = this.ucConnector.getVolume(volumeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MemberAction memberAction = MemberAction.NO_ACTION;
            if (volumeInfo == null) {
                memberAction = nextElement.getMemberAction(null, null);
            } else if (this.noMismatchInExternalIdentifier(volumeInfo.getVolume_id(), nextElement)) {
                memberAction = nextElement.getMemberAction(this.getDateFromLong(volumeInfo.getCreated_at()), this.getDateFromLong(volumeInfo.getUpdated_at()));
            }
            this.takeAction(this.context.getAnchorGUID(nextElement.getElement()), super.getUCSchemaFromMember(nextElement), memberAction, nextElement, volumeInfo);
        }
        return volumeIterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaInfo> ucSchemaList = this.ucConnector.listSchemas(this.catalogName);
        if (ucSchemaList != null) {
            for (SchemaInfo schemaInfo : ucSchemaList) {
                List<VolumeInfo> ucVolumeList;
                String schemaGUID;
                if (schemaInfo == null || (schemaGUID = (String)this.ucFullNameToEgeriaGUID.get(schemaInfo.getFull_name())) == null || (ucVolumeList = this.ucConnector.listVolumes(this.catalogName, schemaInfo.getName())) == null) continue;
                for (VolumeInfo volumeInfo : ucVolumeList) {
                    if (volumeInfo == null || this.ucFullNameToEgeriaGUID.get(volumeInfo.getFull_name()) != null) continue;
                    String ucVolumeQualifiedName = this.getQualifiedName(volumeInfo.getFull_name());
                    MemberElement memberElement = iterator.getMemberByQualifiedName(ucVolumeQualifiedName);
                    MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(volumeInfo.getCreated_at()), this.getDateFromLong(volumeInfo.getUpdated_at()));
                    if (!this.noMismatchInExternalIdentifier(volumeInfo.getVolume_id(), memberElement)) continue;
                    this.takeAction(schemaGUID, volumeInfo.getSchema_name(), memberAction, memberElement, volumeInfo);
                }
            }
        }
    }

    private void takeAction(String schemaGUID, String schemaName, MemberAction memberAction, MemberElement memberElement, VolumeInfo volumeInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(schemaGUID, volumeInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(volumeInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(schemaName, memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(volumeInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(volumeInfo);
            }
        }
    }

    private void createElementInEgeria(String schemaGUID, VolumeInfo volumeInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ucVolumeGUID;
        String parentLinkTypeName = OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName;
        boolean parentAtEnd1 = true;
        if (this.templateGUID != null) {
            ElementProperties replacementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.PATH_NAME.name, super.getPathNameFromStorageLocation(volumeInfo.getStorage_location()));
            ucVolumeGUID = this.openMetadataAccess.getMetadataElementFromTemplate(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), schemaGUID, false, schemaGUID, null, null, this.templateGUID, replacementProperties, this.getPlaceholderProperties(volumeInfo), schemaGUID, parentLinkTypeName, null, true);
        } else {
            String qualifiedName = super.getQualifiedName(volumeInfo.getFull_name());
            ucVolumeGUID = this.openMetadataAccess.createMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, schemaGUID, false, schemaGUID, null, null, this.getElementProperties(qualifiedName, volumeInfo), schemaGUID, parentLinkTypeName, null, true);
            HashMap<String, String> facetProperties = new HashMap<String, String>();
            facetProperties.put(UnityCatalogPlaceholderProperty.VOLUME_TYPE.getName(), volumeInfo.getVolume_type());
            facetProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), volumeInfo.getStorage_location());
            super.addPropertyFacet(ucVolumeGUID, qualifiedName, volumeInfo, facetProperties);
        }
        this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, ucVolumeGUID, this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(volumeInfo, volumeInfo.getSchema_name(), UnityCatalogPlaceholderProperty.VOLUME_NAME.getName(), "volume", volumeInfo.getVolume_id(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.ucFullNameToEgeriaGUID.put(volumeInfo.getFull_name(), ucVolumeGUID);
    }

    private void updateElementInEgeria(VolumeInfo volumeInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaVolumeGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(this.catalogGUID, this.catalogQualifiedName, egeriaVolumeGUID, false, this.getElementProperties(volumeInfo));
        this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, egeriaVolumeGUID, this.entityTypeName, volumeInfo.getVolume_id());
    }

    private void createElementInThirdParty(String schemaName, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        VolumeInfo volumeInfo = this.ucConnector.createVolume(super.getUCNameFromMember(memberElement), this.catalogName, schemaName, super.getUCCommentFomMember(memberElement), this.getUCVolumeTypeFromMember(memberElement), super.getUCStorageLocationFromMember(memberElement));
        if (memberElement.getExternalIdentifier() == null) {
            this.context.addExternalIdentifier(this.catalogGUID, this.catalogQualifiedName, this.catalogTypeName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(volumeInfo, volumeInfo.getSchema_name(), UnityCatalogPlaceholderProperty.VOLUME_NAME.getName(), "volume", volumeInfo.getVolume_id(), PermittedSynchronization.TO_THIRD_PARTY));
        } else {
            this.context.confirmSynchronization(this.catalogGUID, this.catalogQualifiedName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), volumeInfo.getVolume_id());
        }
    }

    private String getUCVolumeTypeFromMember(MemberElement memberElement) {
        Map vendorProperties = memberElement.getVendorProperties("Unity Catalog (UC)");
        if (vendorProperties != null) {
            return (String)vendorProperties.get(UnityCatalogPlaceholderProperty.VOLUME_TYPE.getName());
        }
        return null;
    }

    private void updateElementInThirdParty(VolumeInfo volumeInfo, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.VOLUME_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), volumeInfo.getFull_name(), this.ucServerEndpoint));
        this.context.confirmSynchronization(this.catalogGUID, this.catalogName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), volumeInfo.getVolume_id());
    }

    private void deleteElementInThirdParty(VolumeInfo volumeInfo) throws PropertyServerException {
        String methodName = "deleteElementInThirdParty";
        this.auditLog.logMessage("deleteElementInThirdParty", UCAuditCode.UC_ELEMENT_DELETE.getMessageDefinition(this.connectorName, volumeInfo.getFull_name(), this.ucServerEndpoint));
        this.ucConnector.deleteVolume(volumeInfo.getFull_name());
    }

    private Map<String, String> getPlaceholderProperties(VolumeInfo info) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), info.getCatalog_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), info.getSchema_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.VOLUME_NAME.getName(), info.getName());
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), info.getComment());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), null);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), info.getStorage_location());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.VOLUME_TYPE.getName(), info.getVolume_type());
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(VolumeInfo info) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, info.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, info.getFull_name());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, info.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PATH_NAME.name, this.getPathNameFromStorageLocation(info.getStorage_location()));
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, VolumeInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }
}

