/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.userauthn.auth.model.LoginRequest;
import org.odpi.openmetadata.userauthn.auth.service.TokenService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="API: User Security Services", description="The user security services provide user authentication services to a client program, plus identification details about this runtime implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
public class AuthController {
    private final TokenService tokenService;
    private final AuthenticationManager authenticationManager;

    public AuthController(TokenService tokenService, AuthenticationManager authenticationManager) {
        this.tokenService = tokenService;
        this.authenticationManager = authenticationManager;
    }

    @PostMapping(value={"/api/token"})
    @Operation(summary="generateUserToken", description="Validate the user's password and return a bearer token for the user.  This is passed on subsequent API requests.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
    public String token(@RequestBody LoginRequest userLogin) throws AuthenticationException {
        Authentication authentication = userLogin.userId() != null ? this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userLogin.userId(), (Object)userLogin.password())) : this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userLogin.username(), (Object)userLogin.password()));
        return this.tokenService.generateToken(authentication);
    }

    @PostMapping(value={"/api/token"}, params={"username", "password"})
    @Operation(summary="generateUserToken(username, password)", description="Validate the user's password and return a bearer token for the user.  This is passed on subsequent API requests.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
    public String token(@RequestParam String username, @RequestParam String password) throws AuthenticationException {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        return this.tokenService.generateToken(authentication);
    }
}

