/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth.ldap;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@EnableWebSecurity
@Configuration(value="securityConfig")
@Order(value=-2147483648)
@ConditionalOnProperty(value={"authentication.source"}, havingValue="ldap", matchIfMissing=true)
class LDAPSecurityConfig {
    @Value(value="${ldap.user.search.base}")
    protected String userSearchBase;
    @Value(value="${ldap.user.search.filter}")
    protected String userSearchFilter;
    @Value(value="${ldap.group.search.base}")
    protected String groupSearchBase;
    @Value(value="${ldap.group.search.filter}")
    protected String groupSearchFilter;
    @Value(value="${ldap.url}")
    protected String ldapURL;
    @Value(value="#{'${ldap.user.dn.patterns}'.split(';')}")
    protected String[] userDnPatterns;
    @Value(value="${ldap.npa.dn}")
    protected String npaDn;
    @Value(value="${ldap.npa.password}")
    protected String npaPassword;
    @Value(value="${ldap.group.role.attribute}")
    protected String roleAttribute;

    LDAPSecurityConfig() {
    }

    @Bean
    @ConditionalOnProperty(value={"authentication.source"}, havingValue="ad")
    public LdapAuthenticationProvider getActiveDirectoryAuthenticationProvider() {
        DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(this.ldapURL);
        ldapContextSource.setUserDn(this.npaDn);
        ldapContextSource.setPassword(this.npaPassword);
        ldapContextSource.setCacheEnvironmentProperties(true);
        ldapContextSource.setAnonymousReadOnly(false);
        ldapContextSource.setPooled(true);
        ldapContextSource.afterPropertiesSet();
        BindAuthenticator authenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
        authenticator.setUserDnPatterns(this.userDnPatterns);
        LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator);
        ldapAuthenticationProvider.setUserDetailsContextMapper((UserDetailsContextMapper)new InetOrgPersonContextMapper());
        return ldapAuthenticationProvider;
    }
}

