/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth.service;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.odpi.openmetadata.userauthn.auth.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Autowired
    RoleService roleService;
    private final JwtEncoder encoder;

    public TokenService(JwtEncoder encoder) {
        this.encoder = encoder;
    }

    public String generateToken(Authentication authentication) {
        Instant now = Instant.now();
        List<String> authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        Collection<String> scope = this.roleService.extractUserAppRoles(authorities);
        JwtClaimsSet claims = JwtClaimsSet.builder().issuer("self").issuedAt(now).expiresAt(now.plus(1L, ChronoUnit.HOURS)).subject(authentication.getName()).claim("visibleComponents", this.roleService.getVisibleComponents(scope)).claim("scope", scope).build();
        return this.encoder.encode(JwtEncoderParameters.from((JwtClaimsSet)claims)).getTokenValue();
    }
}

