/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.userauthn.auth.TokenClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@Tag(name="API: User Security Services", description="The user security services provide user authentication services to a client program, plus identification details about this runtime implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
@RequestMapping(value={"/api/logout"})
public class LogoutController {
    @Autowired(required=false)
    TokenClient tokenClient;

    @GetMapping
    @Operation(summary="logout", description="Invalidate the user's token supplied in the request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
    public void logout(HttpServletRequest request) throws HttpClientErrorException {
        String token = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("Authorization");
        if (this.tokenClient != null && token != null) {
            this.tokenClient.del(token);
        }
    }
}

