/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth.demo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.userauthn.auth.demo.User;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties(prefix="egeria", ignoreUnknownFields=false, ignoreInvalidFields=false)
public class DemoUsers {
    private final Map<String, User> demoUsers = new HashMap<String, User>();

    public Map<String, User> getDemoUsers() {
        return this.demoUsers;
    }

    public User getUser(String username) {
        User u1 = new User();
        User u2 = this.demoUsers.get(username);
        if (u2 != null) {
            u1.setUsername(u2.getUsername());
            u1.setPassword(new BCryptPasswordEncoder().encode((CharSequence)u2.getPassword()));
            u1.setAvatarUrl(u2.getAvatarUrl());
            u1.setId(u2.getId());
            u1.setRoles(new ArrayList<String>(u2.getRoles()));
            u1.setName(u2.getName());
        }
        return u1;
    }
}

