/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth.ldap;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@Configuration
public class ActiveDirectoryLDAPSecurityConfig {
    @Value(value="${ldap.domain}")
    private String ldapDomain;
    @Value(value="${ldap.url}")
    protected String ldapURL;
    @Value(value="${ldap.user.search.base}")
    protected String userSearchBase;
    @Value(value="${ldap.user.search.filter}")
    protected String userSearchFilter;

    @Bean
    @ConditionalOnProperty(value={"authentication.source"}, havingValue="ad")
    public ActiveDirectoryLdapAuthenticationProvider getActiveDirectoryAuthenticationProvider() {
        ActiveDirectoryLdapAuthenticationProvider adProvider = new ActiveDirectoryLdapAuthenticationProvider(this.ldapDomain, this.ldapURL, this.userSearchBase);
        adProvider.setSearchFilter(this.userSearchFilter);
        adProvider.setUserDetailsContextMapper((UserDetailsContextMapper)new InetOrgPersonContextMapper());
        adProvider.setConvertSubErrorCodesToExceptions(true);
        adProvider.setUseAuthenticationRequestCredentials(true);
        return adProvider;
    }
}

