/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import org.odpi.openmetadata.userauthn.auth.TokenClient;

public class TokenRedisClient
implements TokenClient {
    private RedisClient redisClient;
    private StatefulRedisConnection<String, String> connection;
    private RedisCommands<String, String> commands;

    public TokenRedisClient(String host, int port) {
        RedisURI redisUri = RedisURI.Builder.redis((String)host).withPort(port).build();
        this.redisClient = RedisClient.create((RedisURI)redisUri);
        this.connection = this.redisClient.connect();
        this.commands = this.connection.sync();
    }

    @Override
    public void shutdownClient() {
        this.connection.close();
        this.redisClient.shutdown();
    }

    @Override
    public String set(String key, long seconds, String value) {
        return this.commands.setex((Object)key, seconds, (Object)value);
    }

    @Override
    public String set(String key, String value) {
        return this.commands.set((Object)key, (Object)value);
    }

    @Override
    public String setKeepTTL(String key, String value) {
        return this.commands.set((Object)key, (Object)value, SetArgs.Builder.keepttl());
    }

    @Override
    public String get(String key) {
        return (String)this.commands.get((Object)key);
    }

    @Override
    public Long ttl(String key) {
        return this.commands.ttl((Object)key);
    }

    public Long exists(String ... keys) {
        return this.commands.exists((Object[])keys);
    }

    @Override
    public void del(String ... keys) {
        this.commands.del((Object[])keys);
    }
}

