/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.MDC;

public class LoggingRequestFilter
implements Filter {
    private String path;

    public LoggingRequestFilter(String path) {
        this.path = path;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpRequest.getRequestURI();
        if (!this.path.equals(requestURI)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        MDC.put((String)"remoteAddress", (String)httpRequest.getRemoteAddr());
        MDC.put((String)"remoteHost", (String)httpRequest.getRemoteHost());
        MDC.put((String)"userId", (String)httpRequest.getParameter("userId"));
        MDC.put((String)"sessionId", (String)httpRequest.getSession().getId());
        Collections.list(httpRequest.getHeaderNames()).forEach(name -> MDC.put((String)name, (String)httpRequest.getHeader(name)));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        MDC.clear();
    }
}

