/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.odpi.openmetadata.userauthn.auth.RSAGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableWebSecurity
@EnableMethodSecurity
@Configuration
public class SecurityConfig {
    @Value(value="${cors.allowed-origins}")
    List<String> allowedOrigins;
    private RSAKey rsaKey = RSAGenerator.generateRSAKeyPair();

    @Bean
    public AuthenticationManager authManager(AuthenticationProvider authProvider) {
        return new ProviderManager(new AuthenticationProvider[]{authProvider});
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource() {
        this.rsaKey = RSAGenerator.generateRSAKeyPair();
        JWKSet jwkSet = new JWKSet((JWK)this.rsaKey);
        return (jwkSelector, securityContext) -> jwkSelector.select(jwkSet);
    }

    @Bean
    JwtEncoder jwtEncoder(JWKSource<SecurityContext> jwks) {
        return new NimbusJwtEncoder(jwks);
    }

    @Bean
    JwtDecoder jwtDecoder() throws JOSEException {
        return NimbusJwtDecoder.withPublicKey((RSAPublicKey)this.rsaKey.toRSAPublicKey()).build();
    }

    @Bean
    @ConditionalOnProperty(value={"cors.allowed-origins"})
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**").allowedOrigins(SecurityConfig.this.allowedOrigins.toArray(new String[0])).allowedMethods(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE"}).allowedHeaders(new String[]{"Authorization", "Content-type"});
            }
        };
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)httpSecurity.cors().and()).csrf(AbstractHttpConfigurer::disable).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/api/about"})).permitAll().requestMatchers(new String[]{"/api/token"})).permitAll().requestMatchers(new String[]{"/api/servers/*/token"})).permitAll().requestMatchers(new String[]{"/api/public/**"})).permitAll().requestMatchers(new String[]{"/swagger-ui/**"})).permitAll().requestMatchers(new String[]{"/open-metadata/**"})).permitAll().requestMatchers(new String[]{"/servers/*/open-metadata/**"})).permitAll().requestMatchers(new String[]{"/v3/api-docs/**"})).permitAll().anyRequest()).authenticated()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).oauth2ResourceServer(OAuth2ResourceServerConfigurer::jwt).build();
    }
}

