/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.odpi.openmetadata.userauthn.auth.TokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TokenLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenLogoutSuccessHandler.class);
    private final TokenClient tokenClient;

    TokenLogoutSuccessHandler(TokenClient tokenClient) {
        this.tokenClient = tokenClient;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String refererUrl = request.getHeader("Referer");
        log.debug("Logout from: {}", (Object)refererUrl);
        String token = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("Authorization");
        if (this.tokenClient != null && token != null) {
            this.tokenClient.del(token);
        }
        response.sendRedirect("login?logoutSuccessful");
        super.onLogoutSuccess(request, response, authentication);
    }
}

