/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.userauthn.TokenService;
import org.odpi.openmetadata.userauthn.auth.LoginRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="API: User Security Services", description="The user security services provide user authentication services to a client program, plus identification details about this runtime implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
public class AuthController {
    private final TokenService tokenService;
    private final AuthenticationManager authenticationManager;

    public AuthController(TokenService tokenService, AuthenticationManager authenticationManager) {
        this.tokenService = tokenService;
        this.authenticationManager = authenticationManager;
    }

    @PostMapping(value={"/api/token"})
    @Operation(summary="generateUserToken", description="Validate the user's password and return a bearer token for the user.  This is passed on subsequent API requests.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
    public String token(@RequestBody LoginRequest userLogin) throws AuthenticationException {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)userLogin.userId(), (Object)userLogin.password()));
        return this.tokenService.generateToken(authentication);
    }

    @PostMapping(value={"/api/servers/{serverName}/token"})
    @Operation(summary="generateUserToken", description="Validate the user's password and return a bearer token for the user.  This is passed on subsequent API requests.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/metadata-security/overview"))
    public String serverToken(@PathVariable String serverName, @RequestBody LoginRequest userLogin) throws AuthenticationException {
        return this.token(userLogin);
    }
}

