/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(value={"authentication.source"}, havingValue="platform")
public class PlatformSecurityConfig {
    @Autowired
    @Qualifier(value="userService")
    private UserDetailsService userDetailsService;

    @Bean
    public AuthenticationProvider getPlatformAuthenticationProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService(this.userDetailsService);
        authProvider.setPasswordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
        return authProvider;
    }
}

