/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreCollectionProperty;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccountStatus;
import org.odpi.openmetadata.metadatasecurity.properties.OpenMetadataUserAccount;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class PlatformUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private OpenMetadataUserAccount openMetadataUserAccount = null;

    public PlatformUserDetails(OpenMetadataUserAccount openMetadataUserAccount) {
        this.openMetadataUserAccount = openMetadataUserAccount;
    }

    public boolean isAccountNonExpired() {
        return this.openMetadataUserAccount != null && this.openMetadataUserAccount.getUserAccountStatus() != null && this.openMetadataUserAccount.getUserAccountStatus() != UserAccountStatus.DISABLED;
    }

    public boolean isAccountNonLocked() {
        return this.openMetadataUserAccount != null && this.openMetadataUserAccount.getUserAccountStatus() != null && this.openMetadataUserAccount.getUserAccountStatus() != UserAccountStatus.DISABLED && this.openMetadataUserAccount.getUserAccountStatus() != UserAccountStatus.LOCKED;
    }

    public boolean isCredentialsNonExpired() {
        return this.openMetadataUserAccount != null && this.openMetadataUserAccount.getUserAccountStatus() != null && this.openMetadataUserAccount.getUserAccountStatus() == UserAccountStatus.AVAILABLE;
    }

    public boolean isEnabled() {
        return this.openMetadataUserAccount != null && this.openMetadataUserAccount.getUserAccountStatus() != null;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.openMetadataUserAccount != null) {
            ArrayList<CallSite> authorities = new ArrayList<CallSite>();
            authorities.add((CallSite)((Object)("User " + this.openMetadataUserAccount.getUserId())));
            if (this.openMetadataUserAccount.getSecurityRoles() != null) {
                for (String securityRole : this.openMetadataUserAccount.getSecurityRoles()) {
                    if (securityRole == null) continue;
                    authorities.add((CallSite)((Object)("SecurityRole " + securityRole)));
                }
            }
            if (this.openMetadataUserAccount.getSecurityGroups() != null) {
                for (String securityGroup : this.openMetadataUserAccount.getSecurityGroups()) {
                    if (securityGroup == null) continue;
                    authorities.add((CallSite)((Object)("SecurityGroup " + securityGroup)));
                }
            }
            return AuthorityUtils.createAuthorityList((String[])authorities.toArray(new String[0]));
        }
        return AuthorityUtils.createAuthorityList((String[])new String[0]);
    }

    public String getPassword() {
        if (this.openMetadataUserAccount != null && this.openMetadataUserAccount.getSecrets() != null) {
            if (this.openMetadataUserAccount.getSecrets().get(SecretsStoreCollectionProperty.ENCRYPTED_PASSWORD.getName()) != null) {
                return (String)this.openMetadataUserAccount.getSecrets().get(SecretsStoreCollectionProperty.ENCRYPTED_PASSWORD.getName());
            }
            if (this.openMetadataUserAccount.getSecrets().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()) != null) {
                return new BCryptPasswordEncoder().encode((CharSequence)this.openMetadataUserAccount.getSecrets().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()));
            }
        }
        return null;
    }

    public String getUsername() {
        if (this.openMetadataUserAccount != null) {
            return this.openMetadataUserAccount.getUserId();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.openMetadataUserAccount != null) {
            return this.openMetadataUserAccount.getUserName();
        }
        return null;
    }

    public String getDistinguishedName() {
        if (this.openMetadataUserAccount != null) {
            return this.openMetadataUserAccount.getDistinguishedName();
        }
        return null;
    }

    public String toString() {
        return "PlatformUserDetails{openMetadataUserAccount=" + this.openMetadataUserAccount + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        PlatformUserDetails that = (PlatformUserDetails)objectToCompare;
        return Objects.equals(this.openMetadataUserAccount, that.openMetadataUserAccount);
    }

    public int hashCode() {
        return Objects.hash(this.openMetadataUserAccount);
    }
}

