/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn.auth;

import org.odpi.openmetadata.metadatasecurity.properties.OpenMetadataUserAccount;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.userauthn.auth.PlatformUserDetails;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userService")
@ConditionalOnProperty(value={"authentication.source"}, havingValue="platform")
public class PlatformUserDetailsService
implements UserDetailsService {
    private final AccountStatusUserDetailsChecker detailsChecker = new AccountStatusUserDetailsChecker();

    public final PlatformUserDetails loadUserByUsername(String userId) throws UsernameNotFoundException {
        OpenMetadataUserAccount userAccount = OpenMetadataPlatformSecurityVerifier.getUser((String)userId);
        if (userAccount != null) {
            PlatformUserDetails user = new PlatformUserDetails(userAccount);
            this.detailsChecker.check((UserDetails)user);
            return user;
        }
        throw new UsernameNotFoundException("No user called: " + userId);
    }
}

