/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userauthn;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.odpi.openmetadata.userauthn.auth.PlatformUserDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private final JwtEncoder encoder;

    public TokenService(JwtEncoder encoder) {
        this.encoder = encoder;
    }

    public String generateToken(Authentication authentication) {
        Object object = authentication.getPrincipal();
        if (object instanceof PlatformUserDetails) {
            PlatformUserDetails platformUserDetails = (PlatformUserDetails)object;
            Instant now = Instant.now();
            JwtClaimsSet claims = platformUserDetails.getDistinguishedName() == null ? JwtClaimsSet.builder().issuer("self").issuedAt(now).expiresAt(now.plus(1L, ChronoUnit.HOURS)).subject(authentication.getName()).claim("displayName", (Object)platformUserDetails.getDisplayName()).build() : JwtClaimsSet.builder().issuer("self").issuedAt(now).expiresAt(now.plus(1L, ChronoUnit.HOURS)).subject(authentication.getName()).claim("displayName", (Object)platformUserDetails.getDisplayName()).claim("dn", (Object)platformUserDetails.getDistinguishedName()).build();
            return this.encoder.encode(JwtEncoderParameters.from((JwtClaimsSet)claims)).getTokenValue();
        }
        return null;
    }
}

