/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.validmetadata.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataClassificationDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefGallery;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefLink;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefGalleryResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueDetailListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.validmetadata.server.ValidMetadataInstanceHandler;
import org.slf4j.LoggerFactory;

public class ValidMetadataRESTServices
extends TokenController {
    private static final ValidMetadataInstanceHandler instanceHandler = new ValidMetadataInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidMetadataRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setUpValidMetadataValue(String serverName, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setUpValidMetadataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setUpValidMetadataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataValue");
            if (requestBody != null) {
                OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "setUpValidMetadataValue");
                client.setUpValidMetadataValue(userId, typeName, propertyName, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataValue", serverName, ValidMetadataValue.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapName(String serverName, String typeName, String propertyName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setUpValidMetadataMapName");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setUpValidMetadataMapName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapName");
            if (requestBody != null) {
                OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "setUpValidMetadataMapName");
                client.setUpValidMetadataMapName(userId, typeName, propertyName, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapName", serverName, ValidMetadataValue.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setUpValidMetadataMapValue(String serverName, String typeName, String propertyName, String mapName, ValidMetadataValue requestBody) {
        String methodName = "setUpValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setUpValidMetadataMapValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setUpValidMetadataMapValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setUpValidMetadataMapValue");
            if (requestBody != null) {
                OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "setUpValidMetadataMapValue");
                client.setUpValidMetadataMapValue(userId, typeName, propertyName, mapName, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setUpValidMetadataMapValue", serverName, ValidMetadataValue.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setUpValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataValue(String serverName, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearValidMetadataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearValidMetadataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "clearValidMetadataValue");
            client.clearValidMetadataValue(userId, typeName, propertyName, preferredValue);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapName(String serverName, String typeName, String propertyName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearValidMetadataMapName");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearValidMetadataMapName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapName");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "clearValidMetadataMapName");
            client.clearValidMetadataMapName(userId, typeName, propertyName, preferredValue);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidMetadataMapValue(String serverName, String typeName, String propertyName, String mapName, String preferredValue, NullRequestBody requestBody) {
        String methodName = "clearValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearValidMetadataMapValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearValidMetadataMapValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidMetadataMapValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "clearValidMetadataMapValue");
            client.clearValidMetadataMapValue(userId, typeName, propertyName, mapName, preferredValue);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataValue(String serverName, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "validateMetadataValue");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "validateMetadataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "validateMetadataValue");
            response.setFlag(client.validateMetadataValue(userId, typeName, propertyName, actualValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapName(String serverName, String typeName, String propertyName, String actualValue) {
        String methodName = "validateMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "validateMetadataMapName");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "validateMetadataMapName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapName");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "validateMetadataMapName");
            response.setFlag(client.validateMetadataMapName(userId, typeName, propertyName, actualValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse validateMetadataMapValue(String serverName, String typeName, String propertyName, String mapName, String actualValue) {
        String methodName = "validateMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "validateMetadataMapValue");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "validateMetadataMapValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateMetadataMapValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "validateMetadataMapValue");
            response.setFlag(client.validateMetadataMapValue(userId, typeName, propertyName, mapName, actualValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataValue(String serverName, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidMetadataValue");
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidMetadataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidMetadataValue");
            response.setElement(client.getValidMetadataValue(userId, typeName, propertyName, preferredValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapName(String serverName, String typeName, String propertyName, String preferredValue) {
        String methodName = "getValidMetadataMapName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidMetadataMapName");
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidMetadataMapName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapName");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidMetadataMapName");
            response.setElement(client.getValidMetadataMapName(userId, typeName, propertyName, preferredValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueResponse getValidMetadataMapValue(String serverName, String typeName, String propertyName, String mapName, String preferredValue) {
        String methodName = "getValidMetadataMapValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidMetadataMapValue");
        ValidMetadataValueResponse response = new ValidMetadataValueResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidMetadataMapValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataMapValue");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidMetadataMapValue");
            response.setElement(client.getValidMetadataMapValue(userId, typeName, propertyName, mapName, preferredValue));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataMapValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueDetailListResponse getValidMetadataValues(String serverName, String typeName, String propertyName, int startFrom, int pageSize) {
        String methodName = "getValidMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidMetadataValues");
        ValidMetadataValueDetailListResponse response = new ValidMetadataValueDetailListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidMetadataValues");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidMetadataValues");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidMetadataValues");
            response.setElementList(client.getValidMetadataValues(userId, typeName, propertyName, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidMetadataValueListResponse getConsistentMetadataValues(String serverName, String typeName, String propertyName, String mapName, String preferredValue, int startFrom, int pageSize) {
        String methodName = "getConsistentMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getConsistentMetadataValues");
        ValidMetadataValueListResponse response = new ValidMetadataValueListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getConsistentMetadataValues");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsistentMetadataValues");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getConsistentMetadataValues");
            response.setElementList(client.getConsistentMetadataValues(userId, typeName, propertyName, mapName, preferredValue, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConsistentMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConsistentMetadataValues(String serverName, String typeName1, String propertyName1, String mapName1, String preferredValue1, String typeName2, String propertyName2, String mapName2, String preferredValue2, NullRequestBody requestBody) {
        String methodName = "setConsistentMetadataValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setConsistentMetadataValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setConsistentMetadataValues");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConsistentMetadataValues");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "setConsistentMetadataValues");
            client.setConsistentMetadataValues(userId, typeName1, propertyName1, mapName1, preferredValue1, typeName2, propertyName2, mapName2, preferredValue2);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConsistentMetadataValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefGalleryResponse getAllTypes(String serverName) {
        String methodName = "getAllTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAllTypes");
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAllTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllTypes");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getAllTypes");
            OpenMetadataTypeDefGallery typeDefGallery = client.getAllTypes(userId);
            if (typeDefGallery != null) {
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse getTypeDefsByCategory(String serverName, OpenMetadataTypeDefCategory category) {
        String methodName = "getTypeDefsByCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTypeDefsByCategory");
        TypeDefListResponse response = new TypeDefListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTypeDefsByCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeDefsByCategory");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getTypeDefsByCategory");
            response.setTypeDefs(client.findTypeDefsByCategory(userId, category));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypeDefsByCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse getSubTypes(String serverName, String typeName) {
        String methodName = "getSubTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSubTypes");
        TypeDefListResponse response = new TypeDefListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSubTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSubTypes");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getSubTypes");
            response.setTypeDefs(client.getSubTypes(userId, typeName));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSubTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefListResponse getValidRelationshipTypes(String serverName, String typeName) {
        String methodName = "getValidRelationshipTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidRelationshipTypes");
        TypeDefListResponse response = new TypeDefListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidRelationshipTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidRelationshipTypes");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidRelationshipTypes");
            OpenMetadataTypeDef entityDef = client.getTypeDefByName(userId, typeName);
            if (entityDef != null) {
                List<String> entityTypeNames = this.getEntityTypeNames(userId, entityDef, client);
                List relationshipDefs = client.findTypeDefsByCategory(userId, OpenMetadataTypeDefCategory.RELATIONSHIP_DEF);
                if (relationshipDefs != null) {
                    HashMap<String, OpenMetadataRelationshipDef> results = new HashMap<String, OpenMetadataRelationshipDef>();
                    for (OpenMetadataTypeDef typeDef : relationshipDefs) {
                        if (!(typeDef instanceof OpenMetadataRelationshipDef)) continue;
                        OpenMetadataRelationshipDef relationshipDef = (OpenMetadataRelationshipDef)typeDef;
                        for (String entityTypeName : entityTypeNames) {
                            if (entityTypeName.equals(relationshipDef.getEndDef1().getEntityType().getName())) {
                                results.put(relationshipDef.getName(), relationshipDef);
                            }
                            if (!entityTypeName.equals(relationshipDef.getEndDef2().getEntityType().getName())) continue;
                            results.put(relationshipDef.getName(), relationshipDef);
                        }
                    }
                    response.setTypeDefs(new ArrayList(results.values()));
                }
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidRelationshipTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    List<String> getEntityTypeNames(String userId, OpenMetadataTypeDef entityDef, OpenMetadataStoreClient client) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> entityTypeNames = new ArrayList<String>();
        OpenMetadataTypeDef currentEntityDef = entityDef;
        entityTypeNames.add(currentEntityDef.getName());
        while (currentEntityDef.getSuperType() != null) {
            currentEntityDef = client.getTypeDefByName(userId, currentEntityDef.getSuperType().getName());
            entityTypeNames.add(currentEntityDef.getName());
        }
        return entityTypeNames;
    }

    public TypeDefListResponse getValidClassificationTypes(String serverName, String typeName) {
        String methodName = "getValidClassificationTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getValidClassificationTypes");
        TypeDefListResponse response = new TypeDefListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getValidClassificationTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidClassificationTypes");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getValidClassificationTypes");
            OpenMetadataTypeDef entityDef = client.getTypeDefByName(userId, typeName);
            if (entityDef != null) {
                List<String> entityTypeNames = this.getEntityTypeNames(userId, entityDef, client);
                List classificationDefs = client.findTypeDefsByCategory(userId, OpenMetadataTypeDefCategory.CLASSIFICATION_DEF);
                if (classificationDefs != null) {
                    HashMap<String, OpenMetadataClassificationDef> results = new HashMap<String, OpenMetadataClassificationDef>();
                    for (OpenMetadataTypeDef typeDef : classificationDefs) {
                        OpenMetadataClassificationDef classificationDef;
                        if (!(typeDef instanceof OpenMetadataClassificationDef) || (classificationDef = (OpenMetadataClassificationDef)typeDef).getValidEntityDefs() == null) continue;
                        for (String entityTypeName : entityTypeNames) {
                            for (OpenMetadataTypeDefLink assignToEntity : classificationDef.getValidEntityDefs()) {
                                if (!entityTypeName.equals(assignToEntity.getName())) continue;
                                results.put(classificationDef.getName(), classificationDef);
                            }
                        }
                    }
                    response.setTypeDefs(new ArrayList(results.values()));
                }
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getValidClassificationTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByName(String serverName, String name) {
        String methodName = "getTypeDefByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTypeDefByName");
        TypeDefResponse response = new TypeDefResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTypeDefByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeDefByName");
            OpenMetadataStoreClient client = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getTypeDefByName");
            response.setTypeDef(client.getTypeDefByName(userId, name));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTypeDefByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

