/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.validmetadata.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefGalleryResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TypeDefResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueDetailListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;
import org.odpi.openmetadata.viewservices.validmetadata.server.ValidMetadataRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/valid-metadata"})
@Tag(name="API: Valid Metadata OMVS", description="The Valid Metadata OMVS provides APIs for retrieving and updating lists of valid metadata values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/valid-metadata/overview/"))
public class ValidMetadataOMVSResource {
    private final ValidMetadataRESTServices restAPI = new ValidMetadataRESTServices();

    @PostMapping(path={"/setup-value/{propertyName}"})
    @Operation(summary="setUpValidMetadataValue", description="Create or update the valid value for a particular open metadata property name.  If the typeName is null, this valid value applies to properties of this name from all types.  The valid value is stored in the preferredValue property.  If a valid value is already set up for this property (with overlapping effective dates) then the valid value is updated.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse setUpValidMetadataValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestBody ValidMetadataValue requestBody) {
        return this.restAPI.setUpValidMetadataValue(serverName, typeName, propertyName, requestBody);
    }

    @PostMapping(path={"/setup-map-name/{propertyName}"})
    @Operation(summary="setUpValidMetadataMapName", description="Create or update the valid value for a name that can be stored in a particular open metadata property name. This property is of type map from name to string. The mapName is stored in the preferredValue property of validMetadataValue. If the typeName is null, this valid value applies to properties of this name from any open metadata type. If a valid value is already set up for this property (with overlapping effective dates) then the valid value is updated.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse setUpValidMetadataMapName(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestBody ValidMetadataValue requestBody) {
        return this.restAPI.setUpValidMetadataMapName(serverName, typeName, propertyName, requestBody);
    }

    @PostMapping(path={"/setup-map-value/{propertyName}/{mapName}"})
    @Operation(summary="setUpValidMetadataMapValue", description="Create or update the valid value for a name that can be stored in a particular open metadata property name. This property is of type map from name to string. The valid value is stored in the preferredValue property of validMetadataValue. If the typeName is null, this valid value applies to properties of this name from any open metadata type. If a valid value is already set up for this property (with overlapping effective dates) then the valid value is updated.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse setUpValidMetadataMapValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestBody ValidMetadataValue validMetadataValue) {
        return this.restAPI.setUpValidMetadataMapValue(serverName, typeName, propertyName, mapName, validMetadataValue);
    }

    @PostMapping(path={"/clear-value/{propertyName}"})
    @Operation(summary="clearValidMetadataValue", description="Remove a valid value for a property.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse clearValidMetadataValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam(required=false) String preferredValue, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataValue(serverName, typeName, propertyName, preferredValue, requestBody);
    }

    @PostMapping(path={"/clear-map-name/{propertyName}"})
    @Operation(summary="clearValidMetadataMapName", description="Remove a valid map name value for a property.  The match is done on preferred name.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse clearValidMetadataMapName(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam(required=false) String mapName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataMapName(serverName, typeName, propertyName, mapName, requestBody);
    }

    @PostMapping(path={"/clear-map-value/{propertyName}/{mapName}"})
    @Operation(summary="clearValidMetadataMapValue", description="Remove a valid map name value for a property.  The match is done on preferred name.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse clearValidMetadataMapValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam(required=false) String preferredValue, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearValidMetadataMapValue(serverName, typeName, propertyName, mapName, preferredValue, requestBody);
    }

    @GetMapping(path={"/validate-value/{propertyName}"})
    @Operation(summary="validateMetadataValue", description="Validate whether the value found in an open metadata property is valid.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public BooleanResponse validateMetadataValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String actualValue) {
        return this.restAPI.validateMetadataValue(serverName, typeName, propertyName, actualValue);
    }

    @GetMapping(path={"/validate-map-name/{propertyName}"})
    @Operation(summary="validateMetadataMapName", description="Validate whether the name found in an open metadata map property is valid.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public BooleanResponse validateMetadataMapName(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String mapName) {
        return this.restAPI.validateMetadataMapName(serverName, typeName, propertyName, mapName);
    }

    @GetMapping(path={"/validate-map-value/{propertyName}/{mapName}"})
    @Operation(summary="validateMetadataMapValue", description="Validate whether the name found in an open metadata map property is valid.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public BooleanResponse validateMetadataMapValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam String actualValue) {
        return this.restAPI.validateMetadataMapValue(serverName, typeName, propertyName, mapName, actualValue);
    }

    @GetMapping(path={"/get-value/{propertyName}"})
    @Operation(summary="getValidMetadataValue", description="Retrieve details of a specific valid value for a property.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public ValidMetadataValueResponse getValidMetadataValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String preferredValue) {
        return this.restAPI.getValidMetadataValue(serverName, typeName, propertyName, preferredValue);
    }

    @GetMapping(path={"/get-map-name/{propertyName}"})
    @Operation(summary="getValidMetadataMapName", description="Retrieve details of a specific valid name for a map property.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public ValidMetadataValueResponse getValidMetadataMapName(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam String mapName) {
        return this.restAPI.getValidMetadataMapName(serverName, typeName, propertyName, mapName);
    }

    @GetMapping(path={"/get-map-value/{propertyName}/{mapName}"})
    @Operation(summary="getValidMetadataMapValue", description="Retrieve details of a specific valid value for a map name.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public ValidMetadataValueResponse getValidMetadataMapValue(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @PathVariable String mapName, @RequestParam String preferredValue) {
        return this.restAPI.getValidMetadataMapValue(serverName, typeName, propertyName, mapName, preferredValue);
    }

    @GetMapping(path={"/get-valid-metadata-values/{propertyName}"})
    @Operation(summary="getValidMetadataValues", description="Retrieve all the valid values for the requested property.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public ValidMetadataValueDetailListResponse getValidMetadataValues(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidMetadataValues(serverName, typeName, propertyName, startFrom, pageSize);
    }

    @GetMapping(path={"/{propertyName}/consistent-metadata-values"})
    @Operation(summary="getConsistentMetadataValues", description="Retrieve all the consistent valid values for the requested property.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public ValidMetadataValueListResponse getConsistentMetadataValues(@PathVariable String serverName, @RequestParam(required=false) String typeName, @PathVariable String propertyName, @RequestParam(required=false) String mapName, @RequestParam String preferredValue, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConsistentMetadataValues(serverName, typeName, propertyName, mapName, preferredValue, startFrom, pageSize);
    }

    @PostMapping(path={"/{propertyName1}/consistent-metadata-values/{propertyName2}"})
    @Operation(summary="setConsistentMetadataValues", description="Set up consistent metadata values relationship between the two property values.", externalDocs=@ExternalDocumentation(description="Valid Metadata Values", url="https://egeria-project.org/guides/planning/valid-values/overview/"))
    public VoidResponse setConsistentMetadataValues(@PathVariable String serverName, @RequestParam(required=false) String typeName1, @PathVariable String propertyName1, @RequestParam(required=false) String mapName1, @RequestParam String preferredValue1, @RequestParam(required=false) String typeName2, @PathVariable String propertyName2, @RequestParam(required=false) String mapName2, @RequestParam String preferredValue2, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setConsistentMetadataValues(serverName, typeName1, propertyName1, mapName1, preferredValue1, typeName2, propertyName2, mapName2, preferredValue2, requestBody);
    }

    @GetMapping(path={"/open-metadata-types"})
    @Operation(summary="getAllTypes", description="Return the list of types loaded into this server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefGalleryResponse getAllTypes(@PathVariable String serverName) {
        return this.restAPI.getAllTypes(serverName);
    }

    @GetMapping(path={"/open-metadata-types/entity-defs"})
    @Operation(summary="getEntityDefs", description="Returns all the entity type definitions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getEntityDefs(@PathVariable String serverName) {
        return this.restAPI.getTypeDefsByCategory(serverName, OpenMetadataTypeDefCategory.ENTITY_DEF);
    }

    @GetMapping(path={"/open-metadata-types/relationship-defs"})
    @Operation(summary="getRelationshipDefs", description="Returns all the relationship type definitions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getRelationshipDefs(@PathVariable String serverName) {
        return this.restAPI.getTypeDefsByCategory(serverName, OpenMetadataTypeDefCategory.RELATIONSHIP_DEF);
    }

    @GetMapping(path={"/open-metadata-types/classification-defs"})
    @Operation(summary="getClassificationDefs", description="Returns all the classification type definitions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getClassificationDefs(@PathVariable String serverName) {
        return this.restAPI.getTypeDefsByCategory(serverName, OpenMetadataTypeDefCategory.CLASSIFICATION_DEF);
    }

    @GetMapping(path={"/open-metadata-types/sub-types/{typeName}"})
    @Operation(summary="getSubTypes", description="Returns all the TypeDefs for a specific subtype.  If a null result is returned it means the type has no subtypes.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getSubTypes(@PathVariable String serverName, @PathVariable String typeName) {
        return this.restAPI.getSubTypes(serverName, typeName);
    }

    @GetMapping(path={"/open-metadata-types/{typeName}/attached-relationships"})
    @Operation(summary="getValidRelationshipTypes", description="Returns all the TypeDefs for relationships that can be attached to the requested entity type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getValidRelationshipTypes(@PathVariable String serverName, @PathVariable String typeName) {
        return this.restAPI.getValidRelationshipTypes(serverName, typeName);
    }

    @GetMapping(path={"/open-metadata-types/{typeName}/attached-classifications"})
    @Operation(summary="getValidClassificationTypes", description="Returns all the TypeDefs for relationships that can be attached to the requested entity type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefListResponse getValidClassificationTypes(@PathVariable String serverName, @PathVariable String typeName) {
        return this.restAPI.getValidClassificationTypes(serverName, typeName);
    }

    @GetMapping(path={"/open-metadata-types/name/{name}"})
    @Operation(summary="getTypeDefByName", description="Return the TypeDef identified by the unique name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types/"))
    public TypeDefResponse getTypeDefByName(@PathVariable String serverName, @PathVariable String name) {
        return this.restAPI.getTypeDefByName(serverName, name);
    }
}

