/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports.validvalues;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.ReferenceDataManager;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.reports.EgeriaReport;

public class ValidValuesReport {
    private final String serverName;
    private final String platformURLRoot;
    private final String clientUserId;
    private final String validValueRootName;
    private final EgeriaReport report;
    private final PropertyHelper propertyHelper = new PropertyHelper();

    private ValidValuesReport(String serverName, String platformURLRoot, String clientUserId, String validValueRootName) throws IOException {
        String reportFileName = "valid-values-report-" + validValueRootName + ".md";
        this.serverName = serverName;
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
        this.validValueRootName = validValueRootName;
        this.report = new EgeriaReport(reportFileName);
    }

    private void run() {
        String methodName = "run";
        int indentLevel = 0;
        try {
            ReferenceDataManager referenceDataManager = new ReferenceDataManager(this.serverName, this.platformURLRoot, 100);
            OpenMetadataStoreClient openMetadataStoreClient = new OpenMetadataStoreClient(this.serverName, this.platformURLRoot, 100);
            String reportTitle = "Valid Values Report for: ";
            this.report.printReportTitle(indentLevel, "Valid Values Report for: " + this.validValueRootName);
            int detailIndentLevel = indentLevel + 1;
            this.report.printReportSubheading(detailIndentLevel, "Retrieved from " + this.serverName + "@" + this.platformURLRoot + " on " + new Date());
            int startFrom = 0;
            int maxPageSize = 100;
            ArrayList<ValidValueInformation> validValueInformationList = new ArrayList<ValidValueInformation>();
            List validValueElements = referenceDataManager.getValidValueByName(this.clientUserId, this.validValueRootName, startFrom, maxPageSize);
            while (validValueElements != null) {
                for (ValidValueElement validValueElement : validValueElements) {
                    this.gatherValidValues(validValueElement, validValueInformationList, 1, referenceDataManager);
                }
                validValueElements = referenceDataManager.getValidValueByName(this.clientUserId, this.validValueRootName, startFrom += maxPageSize, maxPageSize);
            }
            for (ValidValueInformation validValueInformation : validValueInformationList) {
                this.report.printReportSubheading(validValueInformation.indentLevel, validValueInformation.element.getValidValueProperties().getQualifiedName());
                if (validValueInformation.element.getValidValueProperties().getPreferredValue() == null) continue;
                this.report.printReportLine(validValueInformation.indentLevel + 1, "Preferred value", validValueInformation.element.getValidValueProperties().getPreferredValue());
                this.report.printReportLine(validValueInformation.indentLevel + 1, "Description", validValueInformation.element.getValidValueProperties().getDescription());
                startFrom = 0;
                RelatedMetadataElementList relatedElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, validValueInformation.element.getElementHeader().getGUID(), 0, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom, 500);
                while (relatedElements != null && relatedElements.getElementList() != null) {
                    for (RelatedMetadataElement relatedElement : relatedElements.getElementList()) {
                        if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedElement, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName)) continue;
                        this.report.printReportLine(validValueInformation.indentLevel + 2, "Relationship type", relatedElement.getType().getTypeName());
                        if (relatedElement.getRelationshipProperties() != null) {
                            this.report.printReportSubheading(validValueInformation.indentLevel + 3, "Relationship properties:");
                            for (String propertyName : relatedElement.getRelationshipProperties().getPropertiesAsStrings().keySet()) {
                                this.report.printReportLine(validValueInformation.indentLevel + 4, propertyName, (String)relatedElement.getRelationshipProperties().getPropertiesAsStrings().get(propertyName));
                            }
                        }
                        if (relatedElement.getElement().getElementProperties() != null) {
                            this.report.printReportSubheading(validValueInformation.indentLevel + 4, "Related" + relatedElement.getElement().getType().getTypeName() + "Element properties:");
                            for (String propertyName : relatedElement.getElement().getElementProperties().getPropertiesAsStrings().keySet()) {
                                this.report.printReportLine(validValueInformation.indentLevel + 4, propertyName, (String)relatedElement.getElement().getElementProperties().getPropertiesAsStrings().get(propertyName));
                            }
                        }
                        if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedElement, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName) && !this.propertyHelper.isTypeOf((ElementControlHeader)relatedElement, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName)) continue;
                        this.report.printReportSubheading(validValueInformation.indentLevel + 4, "Assigned reference values: ");
                        int refDataStartFrom = 0;
                        RelatedMetadataElementList relatedRefElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, relatedElement.getElement().getElementGUID(), 0, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), refDataStartFrom, 500);
                        while (relatedRefElements != null && relatedRefElements.getElementList() != null) {
                            for (RelatedMetadataElement relatedRefElement : relatedRefElements.getElementList()) {
                                if (relatedRefElement == null) continue;
                                String propertyType = this.propertyHelper.getStringProperty("Valid Values Report for: ", OpenMetadataProperty.PROPERTY_TYPE.name, relatedRefElement.getRelationshipProperties(), "run");
                                this.report.printReportSubheading(validValueInformation.indentLevel + 5, "Assigned specification property: " + propertyType);
                                if (relatedRefElement.getElement().getElementProperties() == null) continue;
                                for (String propertyName : relatedRefElement.getElement().getElementProperties().getPropertiesAsStrings().keySet()) {
                                    this.report.printReportLine(validValueInformation.indentLevel + 6, propertyName, (String)relatedRefElement.getElement().getElementProperties().getPropertiesAsStrings().get(propertyName));
                                }
                            }
                            relatedRefElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, validValueInformation.element.getElementHeader().getGUID(), 0, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), refDataStartFrom += 500, 500);
                        }
                    }
                    relatedElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, validValueInformation.element.getElementHeader().getGUID(), 0, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom += 500, 500);
                }
            }
            this.report.closeReport();
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.exit(-1);
        }
    }

    private void gatherValidValues(ValidValueElement element, List<ValidValueInformation> validValueInformationList, int currentIndent, ReferenceDataManager referenceDataManager) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ValidValueInformation validValueInformation = new ValidValueInformation();
        validValueInformation.element = element;
        validValueInformation.indentLevel = currentIndent;
        validValueInformation.position = validValueInformationList.size();
        validValueInformationList.add(validValueInformation);
        if (this.propertyHelper.isTypeOf((ElementControlHeader)element.getElementHeader(), OpenMetadataType.VALID_VALUE_SET.typeName)) {
            int startFrom = 0;
            List nestedElements = referenceDataManager.getValidValueSetMembers(this.clientUserId, element.getElementHeader().getGUID(), startFrom, 100);
            while (nestedElements != null) {
                for (ValidValueElement nestedElement : nestedElements) {
                    this.gatherValidValues(nestedElement, validValueInformationList, currentIndent + 1, referenceDataManager);
                }
                nestedElements = referenceDataManager.getValidValueSetMembers(this.clientUserId, element.getElementHeader().getGUID(), startFrom += 100, 100);
            }
        }
    }

    public static void main(String[] args) {
        String serverName = "active-metadata-store";
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        String validValueRoot = "Egeria:ValidMetadataValue:";
        if (args.length > 0) {
            platformURLRoot = args[0];
        }
        if (args.length > 1) {
            clientUserId = args[1];
        }
        if (args.length > 2) {
            serverName = args[2];
        }
        if (args.length > 3) {
            validValueRoot = args[3];
        }
        System.out.println("===============================");
        System.out.println("Valid Values Report:    " + new Date());
        System.out.println("===============================");
        System.out.println("Running against platform: " + platformURLRoot);
        System.out.println("Focused on server: " + serverName);
        System.out.println("Using userId: " + clientUserId);
        System.out.println("Valid Value Root: " + validValueRoot);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            ValidValuesReport report = new ValidValuesReport(serverName, platformURLRoot, clientUserId, validValueRoot);
            report.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }

    static class ValidValueInformation {
        ValidValueElement element = null;
        int indentLevel = 0;
        int position = 0;

        ValidValueInformation() {
        }
    }
}

