/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.ViewGeneratorConnectorBase;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.LogicTable;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.MappedColumn;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.utils.ConnectorUtils;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby.auditlog.DerbyConnectorAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewGeneratorDerbyConnector
extends ViewGeneratorConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(ViewGeneratorDerbyConnector.class);
    private static String databaseUrl;
    private static Connection derbyConnection;
    private static Statement derbyStatement;
    private static DerbyConnectorAuditCode auditCode;
    private String serverAddress;
    private String username;
    private String password;
    private String isCreate;
    private String databaseName;
    private int timeoutInSecond;
    private String gdbNode;
    private String logicTableName;
    private String logicTableDefinition;
    private String getLogicTablesQuery;
    private String gaianFrontendName;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        String actionDescription = "initialize";
        super.initialize(connectorInstanceId, connectionProperties);
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        AdditionalProperties additionalProperties = connectionProperties.getAdditionalProperties();
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (this.omrsAuditLog != null) {
            auditCode = DerbyConnectorAuditCode.CONNECTOR_INITIALIZING;
            this.omrsAuditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        if (endpoint != null) {
            this.serverAddress = endpoint.getAddress();
            AdditionalProperties serverProperty = endpoint.getAdditionalProperties();
            if (this.serverAddress != null && serverProperty != null) {
                this.username = connectionProperties.getUserId();
                this.password = connectionProperties.getClearPassword();
                this.isCreate = serverProperty.getProperty("create");
                this.databaseName = additionalProperties.getProperty("databaseName");
                this.timeoutInSecond = Integer.parseInt(serverProperty.getProperty("timeoutInSecond"));
                databaseUrl = this.serverAddress + "/" + this.databaseName + ";create=" + this.isCreate + ";user=" + this.username + ";password=" + this.password + ";proxy-user=" + this.username + ";proxy-pwd=" + this.password;
                log.debug("The generated databased url is {}.", (Object)databaseUrl);
            } else {
                log.error("Errors in the server configuration. The address of the server cannot be extracted");
                if (this.omrsAuditLog != null) {
                    auditCode = DerbyConnectorAuditCode.CONNECTOR_SERVER_CONFIGURATION_ERROR;
                    this.omrsAuditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
        } else {
            log.error("Errors in server address. The endpoint containing the server address is invalid!");
            if (this.omrsAuditLog != null) {
                auditCode = DerbyConnectorAuditCode.CONNECTOR_SERVER_ADDRESS_ERROR;
                this.omrsAuditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (additionalProperties != null) {
            this.logicTableName = additionalProperties.getProperty("logicTableName");
            this.logicTableDefinition = additionalProperties.getProperty("logicTableDefinition");
            this.gdbNode = additionalProperties.getProperty("gdbNode");
            this.getLogicTablesQuery = additionalProperties.getProperty("getLogicTables");
            this.gaianFrontendName = additionalProperties.getProperty("frontendName");
        } else {
            log.error("Errors in settings of the GaianDB");
            if (this.omrsAuditLog != null) {
                auditCode = DerbyConnectorAuditCode.CONNECTOR_LOGICAL_TABLE_ERROR;
                this.omrsAuditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        this.createDerbyConnection();
        if (derbyConnection != null && this.omrsAuditLog != null) {
            auditCode = DerbyConnectorAuditCode.CONNECTOR_INITIALIZED;
            this.omrsAuditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private boolean deleteLogicalTable(String tableName) {
        String actionDescription = "deleteLogicalTable";
        try {
            derbyStatement = derbyConnection.createStatement();
            derbyStatement.setQueryTimeout(this.timeoutInSecond);
            derbyStatement.executeUpdate("call removelt('" + tableName + "')");
            log.debug("Successfully deleted table: {}.", (Object)tableName);
            return true;
        }
        catch (SQLException e) {
            log.error("Error deleting table", (Throwable)e);
            if (this.omrsAuditLog != null) {
                auditCode = DerbyConnectorAuditCode.CONNECTOR_QUERY_ERROR;
                this.omrsAuditLog.logRecord("deleteLogicalTable", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
            return false;
        }
    }

    private List<LogicTable> getAllLogicTables() {
        ArrayList<LogicTable> logicTableList;
        block3: {
            String actionDescription = "getAllLogicTables";
            logicTableList = new ArrayList<LogicTable>();
            try {
                derbyStatement = derbyConnection.createStatement();
                derbyStatement.setQueryTimeout(this.timeoutInSecond);
                ResultSet resultSet = derbyStatement.executeQuery(this.getLogicTablesQuery);
                while (resultSet.next()) {
                    logicTableList.add(this.extractLogicTableDefinition(resultSet));
                }
            }
            catch (SQLException e) {
                log.error("Error in getting all the logic tables: ", (Throwable)e);
                if (this.omrsAuditLog == null) break block3;
                auditCode = DerbyConnectorAuditCode.CONNECTOR_QUERY_ERROR;
                this.omrsAuditLog.logRecord("getAllLogicTables", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        return logicTableList;
    }

    public boolean executeCustomizedUpdate(String update) {
        String actionDescription = "executeCustomizedUpdate: " + update;
        try {
            derbyStatement = derbyConnection.createStatement();
            derbyStatement.setQueryTimeout(this.timeoutInSecond);
            derbyStatement.executeUpdate(update);
            log.debug("Successfully executed query: {}.", (Object)update);
            return true;
        }
        catch (SQLException e) {
            log.error("Error in executing a customized update!", (Throwable)e);
            if (this.omrsAuditLog != null) {
                auditCode = DerbyConnectorAuditCode.CONNECTOR_QUERY_ERROR;
                this.omrsAuditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
            return false;
        }
    }

    public Map<String, String> processInformationViewEvent(TableContextEvent tableContextEvent) {
        block6: {
            String actionDescription = "processInformationViewTopic";
            if (tableContextEvent == null) {
                log.debug("Object TableContextEvent is null");
                if (this.omrsAuditLog != null) {
                    auditCode = DerbyConnectorAuditCode.CONNECTOR_INBOUND_EVENT_ERROR;
                    this.omrsAuditLog.logRecord("processInformationViewTopic", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                    return Collections.emptyMap();
                }
            }
            try {
                String gaianNodeName = tableContextEvent.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().replace(".", "").toLowerCase();
                String technicalTableName = ConnectorUtils.getLogicTableName((String)"LTT", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                String businessTableName = ConnectorUtils.getLogicTableName((String)"LTB", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                String logicalTableName = ConnectorUtils.getLogicTableName((String)"General", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                List mappedColumns = ConnectorUtils.getMappedColumns((TableContextEvent)tableContextEvent);
                if (mappedColumns == null || mappedColumns.isEmpty()) {
                    log.info("There are no business term associations to columns in the received event, removing existing definitions");
                    if (this.getMatchingTables(gaianNodeName, Arrays.asList(businessTableName, technicalTableName)) != null) {
                        this.deleteLogicalTable(businessTableName);
                        this.deleteLogicalTable(technicalTableName);
                    }
                    break block6;
                }
                return this.createTableDefinitions(tableContextEvent, gaianNodeName, technicalTableName, businessTableName, logicalTableName, mappedColumns);
            }
            catch (Exception e) {
                log.error("Unable to process the event.", (Throwable)e);
            }
        }
        return null;
    }

    private void createDerbyConnection() {
        block2: {
            String actionDescription = "createDerbyConnection";
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                derbyConnection = DriverManager.getConnection(databaseUrl);
                log.info("The connection to database is successfully established!");
            }
            catch (Exception e) {
                log.error("Error in creating the connection to derby: ", (Throwable)e);
                if (this.omrsAuditLog == null) break block2;
                auditCode = DerbyConnectorAuditCode.CONNECTOR_SERVER_CONNECTION_ERROR;
                this.omrsAuditLog.logRecord("createDerbyConnection", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
    }

    private LogicTable getMatchingTables(String gaianNodeName, List<String> tables) {
        log.debug("gaianNodeName: {}", (Object)gaianNodeName);
        log.debug("tables to match in gaian: {}", tables);
        List<Object> logicTableList = new ArrayList();
        logicTableList = this.getAllLogicTables();
        if (logicTableList != null && !logicTableList.isEmpty()) {
            return logicTableList.stream().filter(e -> e.getNodeName().equals(gaianNodeName) && tables.contains(e.getLogicalTableName())).findFirst().orElse(null);
        }
        return null;
    }

    private LogicTable extractLogicTableDefinition(ResultSet sqlResults) throws SQLException {
        String[] defs;
        LogicTable logicTable = new LogicTable();
        HashMap<String, String> defLists = new HashMap<String, String>();
        logicTable.setNodeName(sqlResults.getString(this.gdbNode));
        logicTable.setLogicalTableName(sqlResults.getString(this.logicTableName));
        String def = sqlResults.getString(this.logicTableDefinition);
        for (String column : defs = def.split(", ")) {
            String[] temp = column.split(" ");
            defLists.put(temp[0], temp[1]);
        }
        logicTable.setLogicalTableDefinition(defLists);
        return logicTable;
    }

    private Map<String, String> createTableDefinitions(TableContextEvent tableContextEvent, String gaianNodeName, String technicalTableName, String businessTableName, String logicalTableName, List<MappedColumn> mappedColumns) {
        String methodName = "createTableDefinitions";
        HashMap<String, String> createdTables = new HashMap<String, String>();
        LogicTable backendTable = this.getMatchingTables(gaianNodeName, Collections.singletonList(logicalTableName));
        if (backendTable != null) {
            if (!backendTable.getNodeName().equals(this.gaianFrontendName)) {
                this.createMirroringLogicalTable(logicalTableName, gaianNodeName);
            }
            ConnectorUtils.updateColumnDataType(mappedColumns, (LogicTable)backendTable);
            String updatedTable = this.createTableDefinition(tableContextEvent.getTableSource().getDatabaseSource().getName(), businessTableName, c -> c.getBusinessName(), mappedColumns, gaianNodeName, logicalTableName);
            if (updatedTable != null) {
                createdTables.put("LTB", updatedTable);
            }
            if ((updatedTable = this.createTableDefinition(tableContextEvent.getTableSource().getDatabaseSource().getName(), technicalTableName, c -> c.getTechnicalName(), mappedColumns, gaianNodeName, logicalTableName)) != null) {
                createdTables.put("LTT", updatedTable);
            }
            if (!backendTable.getNodeName().equals(this.gaianFrontendName)) {
                log.info("Remove mirrored logical table: {}", (Object)logicalTableName);
                this.deleteLogicalTable(logicalTableName);
            }
            return createdTables;
        }
        log.error("error");
        return null;
    }

    private void createMirroringLogicalTable(String logicalTableName, String gaianNodeName) {
        log.debug("Set up Logical Table for Gaian node");
        String setLogicalTableForNode = "call setltfornode('" + logicalTableName + "','" + gaianNodeName + "')";
        this.executeCustomizedUpdate(setLogicalTableForNode);
    }

    private String createTableDefinition(String databaseName, String tableName, Function<MappedColumn, String> function, List<MappedColumn> mappedColumns, String gaianNodeName, String logicalTableName) {
        String businessTableCreateStatement = this.buildTableCreateStatement(tableName, mappedColumns, function);
        String setBusinessTableDataSource = this.buildCreateTableDataSourceStatement(databaseName, tableName, gaianNodeName, mappedColumns, logicalTableName);
        boolean queryStatus = this.executeCustomizedUpdate(businessTableCreateStatement);
        if (queryStatus) {
            queryStatus = this.executeCustomizedUpdate(setBusinessTableDataSource);
        }
        if (queryStatus) {
            log.debug("Successfully created table {}", (Object)tableName);
            return tableName;
        }
        log.error("Failed to create table {}", (Object)tableName);
        return null;
    }

    private String buildTableCreateStatement(String tableName, List<MappedColumn> mappedColumns, Function<MappedColumn, String> function) {
        StringBuilder statement = new StringBuilder("call setlt('" + tableName + "','");
        for (MappedColumn mappedColumn : mappedColumns) {
            statement.append(function.apply(mappedColumn)).append(" ").append(mappedColumn.getType()).append(",");
        }
        statement = new StringBuilder(statement.substring(0, statement.length() - 1));
        statement.append("','')");
        return statement.toString();
    }

    private String buildCreateTableDataSourceStatement(String databaseName, String tableName, String gaianNodeName, List<MappedColumn> mappedColumns, String logicalTableName) {
        String connectionName = gaianNodeName.toUpperCase();
        String statementForCreatingDataSource = "call setdsrdbtable('" + tableName + "', '', '" + connectionName + "', '" + logicalTableName + "','', '";
        for (MappedColumn mappedColumn : mappedColumns) {
            statementForCreatingDataSource = statementForCreatingDataSource + mappedColumn.getTechnicalName() + ",";
        }
        statementForCreatingDataSource = statementForCreatingDataSource.substring(0, statementForCreatingDataSource.length() - 1);
        statementForCreatingDataSource = statementForCreatingDataSource + "')";
        return statementForCreatingDataSource;
    }
}

