/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum DerbyConnectorAuditCode {
    CONNECTOR_INITIALIZING("DERBYCONNECTOR-0001", OMRSAuditLogRecordSeverity.INFO, "The connector is being initialized", "The local server has started up a new instance of the derby connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_INITIALIZED("DERBYCONNECTOR-0002", OMRSAuditLogRecordSeverity.INFO, "The derby connector has initialized a new instance for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SHUTDOWN("DERBYCONNECTOR-0003", OMRSAuditLogRecordSeverity.INFO, "The derby connector is shutting down its instance for server {0}", "The local server has requested shut down of a derby connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SERVER_CONFIGURATION_ERROR("DERBYCONNECTOR-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The configuration of the virtualization solution is not valid.", "The local server is unable to create a connector.", "Check the connection configuration"),
    CONNECTOR_SERVER_ADDRESS_ERROR("DERBYCONNECTOR-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the virtualization solution is not valid.", "The local server is unable to create a connector.", "Check if the address of the solution is valid"),
    CONNECTOR_LOGICAL_TABLE_ERROR("DERBYCONNECTOR-0006.", OMRSAuditLogRecordSeverity.EXCEPTION, "The name of the logical table is not valid ", "The local server is unable to create a connector.", "Check if the name of the logical is valid"),
    CONNECTOR_SERVER_CONNECTION_ERROR("DERBYCONNECTOR-0007.", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the virtualization solution cannot be connected.", "The local server is unable to create a connector.", "Check if the address of the solution is accessible."),
    CONNECTOR_QUERY_ERROR("DERBYCONNECTOR-0008", OMRSAuditLogRecordSeverity.EXCEPTION, "The logical table cannot be queried.", "No query result will be provided.", "Check if the query is valid."),
    CONNECTOR_INBOUND_EVENT_ERROR("DERBYCONNECTOR-0009", OMRSAuditLogRecordSeverity.EXCEPTION, "Provided inbound event is invalid.", "No action on database will be executed.", "Check if the event is valid.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private DerbyConnectorAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

