/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.ViewGeneratorConnectorBase;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.LogicTable;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.MappedColumn;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.utils.ConnectorUtils;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby.auditlog.DerbyViewConnectorAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewGeneratorDerbyConnector
extends ViewGeneratorConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(ViewGeneratorDerbyConnector.class);
    private String databaseUrl;
    private Connection derbyConnection;
    private Statement derbyStatement;
    private String serverAddress;
    private String username;
    private String password;
    private String isCreate;
    private String databaseName;
    private int timeoutInSecond;
    private String gdbNode;
    private String logicTableName;
    private String logicTableDefinition;
    private String getLogicTablesQuery;
    private String gaianFrontendName;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        String actionDescription = "initialize";
        super.initialize(connectorInstanceId, connectionProperties);
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        AdditionalProperties connectionAdditionalProperties = connectionProperties.getAdditionalProperties();
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (this.auditLog != null) {
            this.auditLog.logMessage("initialize", DerbyViewConnectorAuditCode.CONNECTOR_INITIALIZING.getMessageDefinition());
        }
        if (endpoint != null) {
            this.serverAddress = endpoint.getAddress();
            AdditionalProperties endpointAdditionalProperties = endpoint.getAdditionalProperties();
            if (this.serverAddress != null && endpointAdditionalProperties != null) {
                this.username = connectionProperties.getUserId();
                this.password = connectionProperties.getClearPassword();
                this.isCreate = endpointAdditionalProperties.getProperty("create");
                this.databaseName = connectionAdditionalProperties.getProperty("databaseName");
                this.timeoutInSecond = Integer.parseInt(endpointAdditionalProperties.getProperty("timeoutInSecond"));
                this.databaseUrl = this.serverAddress + "/" + this.databaseName + ";create=" + this.isCreate + ";user=" + this.username + ";password=" + this.password + ";proxy-user=" + this.username + ";proxy-pwd=" + this.password;
                log.debug("The generated databased url is {}.", (Object)this.databaseUrl);
            } else {
                log.error("Errors in the server configuration. The address of the server cannot be extracted");
                if (this.auditLog != null) {
                    String additionalPropertiesContents = "<null>";
                    if (endpointAdditionalProperties != null) {
                        additionalPropertiesContents = endpointAdditionalProperties.toString();
                    }
                    this.auditLog.logMessage("initialize", DerbyViewConnectorAuditCode.ENDPOINT_CONFIGURATION_ERROR.getMessageDefinition(this.serverAddress, additionalPropertiesContents), connectionProperties.toString());
                }
            }
        } else {
            log.error("Errors in server address. The endpoint containing the server address is missing!");
            if (this.auditLog != null) {
                this.auditLog.logMessage("initialize", DerbyViewConnectorAuditCode.NO_ENDPOINT.getMessageDefinition(), connectionProperties.toString());
            }
        }
        if (connectionAdditionalProperties != null) {
            this.logicTableName = connectionAdditionalProperties.getProperty("logicTableName");
            this.logicTableDefinition = connectionAdditionalProperties.getProperty("logicTableDefinition");
            this.gdbNode = connectionAdditionalProperties.getProperty("gdbNode");
            this.getLogicTablesQuery = connectionAdditionalProperties.getProperty("getLogicTables");
            this.gaianFrontendName = connectionAdditionalProperties.getProperty("frontendName");
        } else {
            log.error("Errors in settings of the GaianDB");
            if (this.auditLog != null) {
                this.auditLog.logMessage("initialize", DerbyViewConnectorAuditCode.CONNECTION_CONFIGURATION_ERROR.getMessageDefinition(), connectionProperties.toString());
            }
        }
        this.createDerbyConnection();
        if (this.derbyConnection != null && this.auditLog != null && this.auditLog != null) {
            this.auditLog.logMessage("initialize", DerbyViewConnectorAuditCode.CONNECTOR_INITIALIZED.getMessageDefinition(this.databaseName, this.serverAddress), connectionProperties.toString());
        }
    }

    private boolean deleteLogicalTable(String tableName) {
        String actionDescription = "deleteLogicalTable";
        try {
            this.derbyStatement = this.derbyConnection.createStatement();
            this.derbyStatement.setQueryTimeout(this.timeoutInSecond);
            this.derbyStatement.executeUpdate("call removelt('" + tableName + "')");
            log.debug("Successfully deleted table: {}.", (Object)tableName);
            return true;
        }
        catch (SQLException e) {
            log.error("Error deleting table", (Throwable)e);
            if (this.auditLog != null) {
                this.auditLog.logException("deleteLogicalTable", DerbyViewConnectorAuditCode.CONNECTOR_QUERY_ERROR.getMessageDefinition(), this.derbyStatement.toString(), (Throwable)e);
            }
            return false;
        }
    }

    private List<LogicTable> getAllLogicTables() {
        ArrayList<LogicTable> logicTableList;
        block3: {
            String actionDescription = "getAllLogicTables";
            logicTableList = new ArrayList<LogicTable>();
            try {
                this.derbyStatement = this.derbyConnection.createStatement();
                this.derbyStatement.setQueryTimeout(this.timeoutInSecond);
                ResultSet resultSet = this.derbyStatement.executeQuery(this.getLogicTablesQuery);
                while (resultSet.next()) {
                    logicTableList.add(this.extractLogicTableDefinition(resultSet));
                }
            }
            catch (SQLException e) {
                log.error("Error in getting all the logic tables: ", (Throwable)e);
                if (this.auditLog == null) break block3;
                this.auditLog.logException("getAllLogicTables", DerbyViewConnectorAuditCode.CONNECTOR_QUERY_ERROR.getMessageDefinition(), this.derbyStatement.toString(), (Throwable)e);
            }
        }
        return logicTableList;
    }

    public boolean executeCustomizedUpdate(String update) {
        String actionDescription = "executeCustomizedUpdate: " + update;
        try {
            this.derbyStatement = this.derbyConnection.createStatement();
            this.derbyStatement.setQueryTimeout(this.timeoutInSecond);
            this.derbyStatement.executeUpdate(update);
            log.debug("Successfully executed query: {}.", (Object)update);
            return true;
        }
        catch (SQLException e) {
            log.error("Error in executing a customized update!", (Throwable)e);
            if (this.auditLog != null) {
                this.auditLog.logException(actionDescription, DerbyViewConnectorAuditCode.CONNECTOR_QUERY_ERROR.getMessageDefinition(), this.derbyStatement.toString(), (Throwable)e);
            }
            return false;
        }
    }

    public Map<String, String> processInformationViewEvent(TableContextEvent tableContextEvent) {
        block6: {
            String actionDescription = "processInformationViewTopic";
            if (tableContextEvent == null) {
                log.debug("Object TableContextEvent is null");
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processInformationViewTopic", DerbyViewConnectorAuditCode.CONNECTOR_INBOUND_EVENT_ERROR.getMessageDefinition());
                    return Collections.emptyMap();
                }
            }
            try {
                String gaianNodeName = tableContextEvent.getTableSource().getDatabaseSource().getEndpointSource().getNetworkAddress().replace(".", "").toLowerCase();
                String technicalTableName = ConnectorUtils.getLogicTableName((String)"LTT", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                String businessTableName = ConnectorUtils.getLogicTableName((String)"LTB", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                String logicalTableName = ConnectorUtils.getLogicTableName((String)"General", (TableContextEvent)tableContextEvent, (String)gaianNodeName);
                List mappedColumns = ConnectorUtils.getMappedColumns((TableContextEvent)tableContextEvent);
                if (mappedColumns == null || mappedColumns.isEmpty()) {
                    log.info("There are no business term associations to columns in the received event, removing existing definitions");
                    if (this.getMatchingTables(gaianNodeName, Arrays.asList(businessTableName, technicalTableName)) != null) {
                        this.deleteLogicalTable(businessTableName);
                        this.deleteLogicalTable(technicalTableName);
                    }
                    break block6;
                }
                return this.createTableDefinitions(tableContextEvent, gaianNodeName, technicalTableName, businessTableName, logicalTableName, mappedColumns);
            }
            catch (Exception e) {
                log.error("Unable to process the event.", (Throwable)e);
            }
        }
        return null;
    }

    private void createDerbyConnection() {
        block2: {
            String actionDescription = "createDerbyConnection";
            String driverClass = "org.apache.derby.jdbc.ClientDriver";
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                this.derbyConnection = DriverManager.getConnection(this.databaseUrl);
                log.info("The connection to database is successfully established!");
            }
            catch (Exception e) {
                log.error("Error in creating the connection to derby: ", (Throwable)e);
                if (this.auditLog == null) break block2;
                this.auditLog.logException("createDerbyConnection", DerbyViewConnectorAuditCode.CONNECTOR_SERVER_CONNECTION_ERROR.getMessageDefinition(this.databaseName, this.serverAddress, "org.apache.derby.jdbc.ClientDriver"), this.databaseUrl, (Throwable)e);
            }
        }
    }

    private LogicTable getMatchingTables(String gaianNodeName, List<String> tables) {
        log.debug("gaianNodeName: {}", (Object)gaianNodeName);
        log.debug("tables to match in gaian: {}", tables);
        List<LogicTable> logicTableList = this.getAllLogicTables();
        if (logicTableList != null && !logicTableList.isEmpty()) {
            return logicTableList.stream().filter(e -> e.getNodeName().equals(gaianNodeName) && tables.contains(e.getLogicalTableName())).findFirst().orElse(null);
        }
        return null;
    }

    private LogicTable extractLogicTableDefinition(ResultSet sqlResults) throws SQLException {
        String[] defs;
        LogicTable logicTable = new LogicTable();
        HashMap<String, String> defLists = new HashMap<String, String>();
        logicTable.setNodeName(sqlResults.getString(this.gdbNode));
        logicTable.setLogicalTableName(sqlResults.getString(this.logicTableName));
        String def = sqlResults.getString(this.logicTableDefinition);
        for (String column : defs = def.split(", ")) {
            String[] temp = column.split(" ");
            defLists.put(temp[0], temp[1]);
        }
        logicTable.setLogicalTableDefinition(defLists);
        return logicTable;
    }

    private Map<String, String> createTableDefinitions(TableContextEvent tableContextEvent, String gaianNodeName, String technicalTableName, String businessTableName, String logicalTableName, List<MappedColumn> mappedColumns) {
        String methodName = "createTableDefinitions";
        HashMap<String, String> createdTables = new HashMap<String, String>();
        LogicTable backendTable = this.getMatchingTables(gaianNodeName, Collections.singletonList(logicalTableName));
        if (backendTable != null) {
            if (!backendTable.getNodeName().equals(this.gaianFrontendName)) {
                this.createMirroringLogicalTable(logicalTableName, gaianNodeName);
            }
            ConnectorUtils.updateColumnDataType(mappedColumns, (LogicTable)backendTable);
            String updatedTable = this.createTableDefinition(tableContextEvent.getTableSource().getDatabaseSource().getName(), businessTableName, c -> c.getBusinessName(), mappedColumns, gaianNodeName, logicalTableName);
            if (updatedTable != null) {
                createdTables.put("LTB", updatedTable);
            }
            if ((updatedTable = this.createTableDefinition(tableContextEvent.getTableSource().getDatabaseSource().getName(), technicalTableName, c -> c.getTechnicalName(), mappedColumns, gaianNodeName, logicalTableName)) != null) {
                createdTables.put("LTT", updatedTable);
            }
            if (!backendTable.getNodeName().equals(this.gaianFrontendName)) {
                log.info("Remove mirrored logical table: {}", (Object)logicalTableName);
                this.deleteLogicalTable(logicalTableName);
            }
            return createdTables;
        }
        log.error("error");
        return null;
    }

    private void createMirroringLogicalTable(String logicalTableName, String gaianNodeName) {
        log.debug("Set up Logical Table {} for Gaian node {}", (Object)logicalTableName, (Object)gaianNodeName);
        String setLogicalTableForNode = "call setltfornode('" + logicalTableName + "','" + gaianNodeName + "')";
        this.executeCustomizedUpdate(setLogicalTableForNode);
    }

    private String createTableDefinition(String databaseName, String tableName, Function<MappedColumn, String> function, List<MappedColumn> mappedColumns, String gaianNodeName, String logicalTableName) {
        String businessTableCreateStatement = this.buildTableCreateStatement(tableName, mappedColumns, function);
        String setBusinessTableDataSource = this.buildCreateTableDataSourceStatement(databaseName, tableName, gaianNodeName, mappedColumns, logicalTableName);
        boolean queryStatus = this.executeCustomizedUpdate(businessTableCreateStatement);
        if (queryStatus) {
            queryStatus = this.executeCustomizedUpdate(setBusinessTableDataSource);
        }
        if (queryStatus) {
            log.debug("Successfully created table {}", (Object)tableName);
            return tableName;
        }
        log.error("Failed to create table {}", (Object)tableName);
        return null;
    }

    private String buildTableCreateStatement(String tableName, List<MappedColumn> mappedColumns, Function<MappedColumn, String> function) {
        StringBuilder statement = new StringBuilder("call setlt('" + tableName + "','");
        for (MappedColumn mappedColumn : mappedColumns) {
            statement.append(function.apply(mappedColumn)).append(" ").append(mappedColumn.getType()).append(",");
        }
        statement = new StringBuilder(statement.substring(0, statement.length() - 1));
        statement.append("','')");
        return statement.toString();
    }

    private String buildCreateTableDataSourceStatement(String databaseName, String tableName, String gaianNodeName, List<MappedColumn> mappedColumns, String logicalTableName) {
        String connectionName = gaianNodeName.toUpperCase();
        String statementForCreatingDataSource = "call setdsrdbtable('" + tableName + "', '', '" + connectionName + "', '" + logicalTableName + "','', '";
        for (MappedColumn mappedColumn : mappedColumns) {
            statementForCreatingDataSource = statementForCreatingDataSource + mappedColumn.getTechnicalName() + ",";
        }
        statementForCreatingDataSource = statementForCreatingDataSource.substring(0, statementForCreatingDataSource.length() - 1);
        statementForCreatingDataSource = statementForCreatingDataSource + "')";
        return statementForCreatingDataSource;
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        if (this.auditLog != null) {
            String actionDescription = "Connector Disconnect";
            this.auditLog.logMessage("Connector Disconnect", DerbyViewConnectorAuditCode.CONNECTOR_SHUTDOWN.getMessageDefinition(this.databaseName, this.serverAddress), this.connectionProperties.toString());
        }
    }
}

