/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.virtualizationservices.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.dataplatform.events.NewViewEvent;
import org.odpi.openmetadata.accessservices.dataplatform.properties.DerivedColumn;
import org.odpi.openmetadata.accessservices.dataplatform.properties.EndpointSource;
import org.odpi.openmetadata.accessservices.dataplatform.properties.TableSource;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseSource;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.ViewGeneratorConnectorBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualizerTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(VirtualizerTopicListener.class);
    private OpenMetadataTopicConnector virtualizerOutboundTopicConnector;
    private ViewGeneratorConnectorBase viewGeneratorConnector;
    private org.odpi.openmetadata.accessservices.informationview.events.EndpointSource endpointSource;
    private String databaseName;
    private String dataSchema;

    public VirtualizerTopicListener(OpenMetadataTopicConnector virtualizerOutboundTopicConnector, ViewGeneratorConnectorBase viewGeneratorConnector, org.odpi.openmetadata.accessservices.informationview.events.EndpointSource endpointSource, String databaseName, String dataSchema) {
        this.virtualizerOutboundTopicConnector = virtualizerOutboundTopicConnector;
        this.viewGeneratorConnector = viewGeneratorConnector;
        this.endpointSource = endpointSource;
        this.databaseName = databaseName;
        this.dataSchema = dataSchema;
    }

    public void processEvent(String event) {
        log.info("The following event is received: " + event);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            TableContextEvent eventObject;
            try {
                eventObject = (TableContextEvent)objectMapper.readValue(event, TableContextEvent.class);
            }
            catch (Exception e) {
                log.info("An event is not Table Context Event, discarded!");
                eventObject = null;
            }
            if (eventObject != null) {
                Map views = this.viewGeneratorConnector.processInformationViewEvent(eventObject);
                List<NewViewEvent> viewEvents = this.generateViewEvents(eventObject, views);
                for (NewViewEvent item : viewEvents) {
                    this.virtualizerOutboundTopicConnector.sendEvent(objectMapper.writeValueAsString((Object)item));
                }
            }
        }
        catch (Exception e) {
            log.error("Error in processing the event from Information View OMAS", (Throwable)e);
        }
    }

    public List<NewViewEvent> generateViewEvents(TableContextEvent tableContextEvent, Map<String, String> createdViews) {
        ArrayList<NewViewEvent> events = new ArrayList<NewViewEvent>();
        try {
            if (createdViews == null || createdViews.isEmpty()) {
                log.info("No views were created, nothing to publish");
            } else {
                for (Map.Entry<String, String> entry : createdViews.entrySet()) {
                    if (entry.getValue() == null) {
                        log.info("No view was created for " + entry.getKey());
                        continue;
                    }
                    events.add(this.createDataPlatformEvent(entry.getKey(), entry.getValue(), tableContextEvent));
                }
                log.debug("Notification is sent out to Information View OMAS");
            }
        }
        catch (Exception e) {
            log.error("Exception: Not able to create views or notify Information View OMAS.", (Throwable)e);
        }
        return events;
    }

    private NewViewEvent createDataPlatformEvent(String viewType, String tableName, TableContextEvent tableContextEvent) {
        NewViewEvent view = this.addConnectionDetailsAndTableContext(new NewViewEvent(), tableName);
        view.setOriginalTableSource(this.convertTableSource(tableContextEvent.getTableSource()));
        ArrayList<DerivedColumn> derivedColumn = new ArrayList<DerivedColumn>();
        for (TableColumn databaseColumn : tableContextEvent.getTableColumns()) {
            if (databaseColumn.getBusinessTerms() == null || databaseColumn.getBusinessTerms().isEmpty()) continue;
            DerivedColumn column = new DerivedColumn();
            if (viewType.equals("LTB")) {
                column.setName(((BusinessTerm)databaseColumn.getBusinessTerms().get(0)).getName().replace(" ", "_"));
            } else {
                column.setName(databaseColumn.getName());
            }
            column.setPosition(databaseColumn.getPosition());
            column.setType(databaseColumn.getType());
            column.setSourceColumn(this.convertSourceColumn(databaseColumn));
            derivedColumn.add(column);
        }
        view.setDerivedColumns(derivedColumn);
        return view;
    }

    private List<org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm> convertBusinessTerm(List<BusinessTerm> businessTerms) {
        if (businessTerms != null && !businessTerms.isEmpty()) {
            ArrayList<org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm> businessTermList = new ArrayList<org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm>();
            for (BusinessTerm businessTerm : businessTerms) {
                org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm businessTermCount = new org.odpi.openmetadata.accessservices.dataplatform.properties.BusinessTerm();
                businessTermCount.setAbbreviation(businessTerm.getAbbreviation());
                businessTermCount.setDescription(businessTerm.getDescription());
                businessTermCount.setDisplayName(businessTerm.getDisplayName());
                businessTermCount.setExamples(businessTerm.getExamples());
                businessTermCount.setGuid(businessTerm.getGuid());
                businessTermCount.setQuery(businessTerm.getQuery());
                businessTermCount.setName(businessTerm.getName());
                businessTermList.add(businessTermCount);
            }
            return businessTermList;
        }
        return null;
    }

    private org.odpi.openmetadata.accessservices.dataplatform.properties.TableColumn convertSourceColumn(TableColumn databaseColumn) {
        org.odpi.openmetadata.accessservices.dataplatform.properties.TableColumn tableColumn = new org.odpi.openmetadata.accessservices.dataplatform.properties.TableColumn();
        tableColumn.setName(databaseColumn.getName());
        tableColumn.setCardinality(databaseColumn.getCardinality());
        tableColumn.setGuid(databaseColumn.getGuid());
        tableColumn.setPosition(databaseColumn.getPosition());
        tableColumn.setPrimaryKey(databaseColumn.isPrimaryKey());
        tableColumn.setDefaultValueOverride(databaseColumn.getDefaultValueOverride());
        tableColumn.setNullable(databaseColumn.isNullable());
        tableColumn.setQualifiedName(databaseColumn.getQualifiedName());
        tableColumn.setType(databaseColumn.getType());
        tableColumn.setUnique(databaseColumn.isUnique());
        tableColumn.setBusinessTerms(this.convertBusinessTerm(databaseColumn.getBusinessTerms()));
        return tableColumn;
    }

    private NewViewEvent addConnectionDetailsAndTableContext(NewViewEvent informationViewEvent, String tableName) {
        TableSource tableSource = new TableSource();
        org.odpi.openmetadata.accessservices.dataplatform.properties.DatabaseSource databaseSource = new org.odpi.openmetadata.accessservices.dataplatform.properties.DatabaseSource();
        tableSource.setDatabaseSource(databaseSource);
        EndpointSource endpointSource1 = this.convertEndpointSource(this.endpointSource);
        databaseSource.setEndpointSource(endpointSource1);
        tableSource.setName(tableName);
        databaseSource.setName(this.databaseName);
        tableSource.setSchemaName(this.dataSchema);
        informationViewEvent.setTableSource(tableSource);
        return informationViewEvent;
    }

    private TableSource convertTableSource(org.odpi.openmetadata.accessservices.informationview.events.TableSource tableSource) {
        TableSource tableSource1 = new TableSource();
        tableSource1.setName(tableSource.getName());
        tableSource1.setSchemaName(tableSource.getSchemaName());
        tableSource1.setGuid(tableSource.getGuid());
        tableSource1.setQualifiedName(tableSource.getQualifiedName());
        tableSource1.setGuid(tableSource.getGuid());
        tableSource1.setAdditionalProperties(tableSource.getAdditionalProperties());
        tableSource1.setDatabaseSource(this.convertDatabaseSource(tableSource.getDatabaseSource()));
        return tableSource1;
    }

    private org.odpi.openmetadata.accessservices.dataplatform.properties.DatabaseSource convertDatabaseSource(DatabaseSource databaseSource) {
        org.odpi.openmetadata.accessservices.dataplatform.properties.DatabaseSource databaseSource1 = new org.odpi.openmetadata.accessservices.dataplatform.properties.DatabaseSource();
        databaseSource1.setName(databaseSource.getName());
        databaseSource1.setGuid(databaseSource.getGuid());
        databaseSource1.setQualifiedName(databaseSource.getQualifiedName());
        databaseSource1.setAdditionalProperties(databaseSource.getAdditionalProperties());
        databaseSource1.setEndpointSource(this.convertEndpointSource(databaseSource.getEndpointSource()));
        return databaseSource1;
    }

    private EndpointSource convertEndpointSource(org.odpi.openmetadata.accessservices.informationview.events.EndpointSource endpointSource) {
        EndpointSource endpointSource1 = new EndpointSource();
        endpointSource1.setConnectorProviderName(endpointSource.getConnectorProviderName());
        endpointSource1.setNetworkAddress(endpointSource.getNetworkAddress());
        endpointSource1.setProtocol(endpointSource.getProtocol());
        endpointSource1.setUser(endpointSource.getUser());
        endpointSource1.setAdditionalProperties(endpointSource.getAdditionalProperties());
        endpointSource1.setGuid(endpointSource.getGuid());
        endpointSource1.setQualifiedName(endpointSource.getQualifiedName());
        return endpointSource1;
    }
}

