/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.LogicTable;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.model.MappedColumn;

public class ConnectorUtils {
    public static final String TECHNICAL_PREFIX = "LTT";
    public static final String BUSINESS_PREFIX = "LTB";
    public static final String GENERAL = "General";

    public static String getLogicTableName(String type, TableContextEvent event, String gaianNodeName) {
        String connectorProviderType = event.getTableSource().getDatabaseSource().getEndpointSource().getConnectorProviderName().toLowerCase();
        String name = type.equals(GENERAL) ? connectorProviderType + "_" + event.getTableSource().getDatabaseSource().getName() + "_" + event.getTableSource().getSchemaName() + "_" + event.getTableSource().getName() : type + "_" + gaianNodeName + "_" + connectorProviderType + "_" + event.getTableSource().getDatabaseSource().getName() + "_" + event.getTableSource().getSchemaName() + "_" + event.getTableSource().getName();
        return name.toUpperCase();
    }

    public static List<MappedColumn> getMappedColumns(TableContextEvent tableContextEvent) {
        ArrayList<MappedColumn> mappedColumns = new ArrayList<MappedColumn>();
        List databaseColumnList = tableContextEvent.getTableColumns();
        for (TableColumn databaseColumn : databaseColumnList) {
            if (databaseColumn.getBusinessTerms() == null || databaseColumn.getBusinessTerms().isEmpty()) continue;
            MappedColumn mappedColumn = new MappedColumn();
            mappedColumn.setBusinessName(((BusinessTerm)databaseColumn.getBusinessTerms().get(0)).getName().replace(" ", "_"));
            mappedColumn.setType(databaseColumn.getType());
            mappedColumn.setTechnicalName(databaseColumn.getName());
            mappedColumns.add(mappedColumn);
        }
        return mappedColumns;
    }

    public static void updateColumnDataType(List<MappedColumn> mappedColumns, LogicTable backEndTable) {
        block0: for (MappedColumn mappedColumn : mappedColumns) {
            for (Map.Entry<String, String> column : backEndTable.getLogicalTableDefinition().entrySet()) {
                if (!mappedColumn.getTechnicalName().equals(column.getKey())) continue;
                mappedColumn.setType(column.getValue());
                continue block0;
            }
        }
    }
}

