/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.virtualizationservices.admin;

import org.odpi.openmetadata.accessservices.informationview.events.EndpointSource;
import org.odpi.openmetadata.adminservices.configuration.properties.VirtualizationConfig;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.virtualizationservices.auditlog.VirtualizationAuditCode;
import org.odpi.openmetadata.governanceservers.virtualizationservices.event.VirtualizerTopicListener;
import org.odpi.openmetadata.governanceservers.virtualizationservices.viewgenerator.ViewGeneratorConnectorBase;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby.ViewGeneratorDerbyConnector;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby.ViewGeneratorDerbyConnectorProvider;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualizationOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationOperationalServices.class);
    private String localServerName;
    private String localServerType;
    private String localMetadataCollectionName;
    private String localOrganizationName;
    private String localServerUserId;
    private String localServerURL;
    private OMRSAuditLog auditLog;
    private OpenMetadataTopicConnector virtualizerInboundTopicConnector;
    private OpenMetadataTopicConnector virtualizerOutboundTopicConnector;
    private ViewGeneratorDerbyConnector virtualizationSolutionConnector;

    public VirtualizationOperationalServices(String localServerName, String localServerType, String localOrganizationName, String localServerUserId, String localServerURL) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.localServerUserId = localServerUserId;
        this.localServerURL = localServerURL;
    }

    public void initialize(VirtualizationConfig virtualizationConfig, OMRSAuditLog auditLog) {
        if (virtualizationConfig != null) {
            Connection virtualizationSolutionConnection;
            Connection ivInTopicConnection;
            String actionDescription = "initialize";
            VirtualizationAuditCode auditCode = VirtualizationAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.auditLog = auditLog;
            Connection virtualizerInboundTopicConnection = virtualizationConfig.getVirtualizerInboundTopic();
            if (virtualizerInboundTopicConnection != null) {
                try {
                    this.virtualizerInboundTopicConnector = this.getTopicConnector(virtualizerInboundTopicConnection);
                }
                catch (Exception e) {
                    auditCode = VirtualizationAuditCode.ERROR_INITIALIZING_IV_OUT_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if ((ivInTopicConnection = virtualizationConfig.getVirtualizerOutboundTopic()) != null) {
                try {
                    this.virtualizerOutboundTopicConnector = this.getTopicConnector(ivInTopicConnection);
                }
                catch (Exception e) {
                    auditCode = VirtualizationAuditCode.ERROR_INITIALIZING_IV_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if ((virtualizationSolutionConnection = virtualizationConfig.getVirtualizationSolutionConnection()) != null) {
                try {
                    ViewGeneratorDerbyConnectorProvider virtualizationConnectorProvider = new ViewGeneratorDerbyConnectorProvider();
                    this.virtualizationSolutionConnector = (ViewGeneratorDerbyConnector)virtualizationConnectorProvider.getConnector(virtualizationSolutionConnection);
                }
                catch (Exception e) {
                    log.error("Error creating derby connector: ", (Throwable)e);
                }
            }
            if (this.virtualizerOutboundTopicConnector != null) {
                try {
                    this.virtualizerOutboundTopicConnector.start();
                    EndpointSource endpointSource = new EndpointSource();
                    String connectorProviderName = (String)virtualizationSolutionConnection.getEndpoint().getAdditionalProperties().get("connectorProviderName");
                    int lastIndexOf = connectorProviderName.lastIndexOf(".");
                    endpointSource.setConnectorProviderName(connectorProviderName.substring(lastIndexOf + 1, connectorProviderName.length()));
                    String aggregatedAddress = virtualizationSolutionConnection.getEndpoint().getAddress();
                    endpointSource.setProtocol(aggregatedAddress.split("//")[0] + "//");
                    endpointSource.setNetworkAddress(aggregatedAddress.split("//")[1].split(":")[0]);
                    endpointSource.setUser(virtualizationSolutionConnection.getUserId());
                    VirtualizerTopicListener virtualizerTopicListener = new VirtualizerTopicListener(this.virtualizerOutboundTopicConnector, (ViewGeneratorConnectorBase)this.virtualizationSolutionConnector, endpointSource, (String)virtualizationSolutionConnection.getAdditionalProperties().get("databaseName"), (String)virtualizationSolutionConnection.getAdditionalProperties().get("dataSchema"));
                    this.virtualizerInboundTopicConnector.registerListener((OpenMetadataTopicListener)virtualizerTopicListener);
                }
                catch (Exception e) {
                    auditCode = VirtualizationAuditCode.ERROR_INITIALIZING_IV_IN_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if (this.virtualizerInboundTopicConnector != null) {
                try {
                    this.virtualizerInboundTopicConnector.start();
                    auditCode = VirtualizationAuditCode.INBOUND_TOPIC_CONNECTOR_INITIALIZED;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
                catch (Exception e) {
                    auditCode = VirtualizationAuditCode.ERROR_INITIALIZING_IV_OUT_TOPIC_CONNECTION;
                    auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            if (this.virtualizationSolutionConnector != null) {
                try {
                    this.virtualizationSolutionConnector.start();
                }
                catch (Exception e) {
                    log.error("Error in starting the derby connector: ", (Throwable)e);
                }
            }
        }
        if (this.virtualizerInboundTopicConnector != null && this.virtualizerOutboundTopicConnector != null && this.virtualizationSolutionConnector != null && this.virtualizerOutboundTopicConnector.isActive() && this.virtualizerInboundTopicConnector.isActive() && this.virtualizationSolutionConnector.isActive()) {
            VirtualizationAuditCode auditCode = VirtualizationAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("Initializing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        log.info("Virtualizer has been started!");
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create topic connector: " + error.toString());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public boolean disconnect(boolean permanent) {
        try {
            this.virtualizerOutboundTopicConnector.disconnect();
            this.virtualizerInboundTopicConnector.disconnect();
            this.virtualizationSolutionConnector.disconnect();
            VirtualizationAuditCode auditCode = VirtualizationAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        catch (Exception e) {
            VirtualizationAuditCode auditCode = VirtualizationAuditCode.ERROR_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return false;
        }
    }
}

