/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.virtualizationservices.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum VirtualizationAuditCode {
    SERVICE_INITIALIZING("VIRTUALIZER-0001", OMRSAuditLogRecordSeverity.INFO, "The Virtualizer is initializing a new server instance", "The local server has started up a new instance of the Virutalizer.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("VIRTUALIZER-0002", OMRSAuditLogRecordSeverity.INFO, "The Virtualizer has initialized a new instance for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("VIRTUALIZER-0003", OMRSAuditLogRecordSeverity.INFO, "The Virtualizer is shutting down its instance for server {0}", "The local server has requested shut down of a Virtualizer instance.", "No action is required.  This is part of the normal operation of the service."),
    INBOUND_TOPIC_CONNECTOR_INITIALIZED("VIRTUALIZER-0004", OMRSAuditLogRecordSeverity.INFO, "The Virtualizer has initialized an event bus connector for Inbound Topic", "The local server has completed initialization of a new event bus connector.", "No action is required.  This is part of the normal operation of the service."),
    ERROR_INITIALIZING_IV_OUT_TOPIC_CONNECTION("VIRTUALIZER-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "Unable to initialize the Information View Out Topic connection", "The connection could not be initialized.", "Review the exception and resolve the configuration. "),
    OUTBOUND_TOPIC_CONNECTOR_INITIALIZED("VIRTUALIZER-0006", OMRSAuditLogRecordSeverity.INFO, "The Virtualizer has initialized an event bus connector for outbound Topic", "The local server has completed initialization of a new event bus connector.", "No action is required.  This is part of the normal operation of the service."),
    ERROR_INITIALIZING_IV_IN_TOPIC_CONNECTION("VIRTUALIZER-0007", OMRSAuditLogRecordSeverity.EXCEPTION, "Unable to initialize the Information View In Topic connection", "The connection could not be initialized.", "Review the exception and resolve the configuration. "),
    ERROR_SHUTDOWN("VIRTUALIZER-008", OMRSAuditLogRecordSeverity.EXCEPTION, "The service is not shutdown properly.", "The connection could not be shutdown.", "Try again. ");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private VirtualizationAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

