/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityProxyMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class AddRelationship
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(AddRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"addRelationship");
    private static final String CLASS_NAME = AddRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid1 eid2 relationship]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          proxy1 (xtdb.api/entity db eid1)          proxy2 (xtdb.api/entity db eid2)          created (.doc (" + AddRelationship.class.getCanonicalName() + ". tx-id eid1 eid2 proxy1 proxy2 relationship))" + AddRelationship.getTxnTimeCalculation("created") + "]         [[:xtdb.api/put created txt]]))";
    private final IPersistentMap xtdbDoc;

    public AddRelationship(Long txId, String entityOneGUID, String entityTwoGUID, PersistentHashMap proxy1, PersistentHashMap proxy2, Relationship relationship) throws Exception {
        try {
            if (proxy1 == null) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityOneGUID), CLASS_NAME, METHOD_NAME);
            }
            if (proxy2 == null) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityTwoGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.entityFromStore(entityOneGUID, (IPersistentMap)proxy1, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)proxy1, entityOneGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityTwoGUID, (IPersistentMap)proxy2, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)proxy2, entityTwoGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.relationshipEnds(entityOneGUID, entityTwoGUID, (IPersistentMap)proxy1, (IPersistentMap)proxy2, relationship.getType().getTypeDefGUID(), CLASS_NAME, METHOD_NAME);
            EntityProxy one = EntityProxyMapping.fromMap((IPersistentMap)proxy1);
            EntityProxy two = EntityProxyMapping.fromMap((IPersistentMap)proxy2);
            relationship.setEntityOneProxy(one);
            relationship.setEntityTwoProxy(two);
            this.xtdbDoc = RelationshipMapping.toMap(relationship);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, Relationship relationship, String entityOneGUID, String entityTwoGUID) throws EntityNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationship.getGUID());
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{EntityProxyMapping.getReference(entityOneGUID), EntityProxyMapping.getReference(entityTwoGUID), relationship});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingRelationship(docId, results, METHOD_NAME);
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        AddRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

