/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.RestoreInstance;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class RestoreRelationship
extends RestoreInstance {
    private static final Logger log = LoggerFactory.getLogger(RestoreRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"restoreRelationship");
    private static final String CLASS_NAME = RestoreRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid user mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db rid)          restored (.doc (" + RestoreRelationship.class.getCanonicalName() + ". tx-id existing user rid mid))" + RestoreRelationship.getTxnTimeCalculation("restored") + "]         [[:xtdb.api/put restored txt]]))";
    private final IPersistentMap xtdbDoc;

    public RestoreRelationship(Long txId, PersistentHashMap existing, String userId, String relationshipGUID, String metadataCollectionId) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), this.getClass().getName(), METHOD_NAME);
            }
            TxnValidations.relationshipFromStore(relationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            try {
                TxnValidations.instanceIsDeleted((IPersistentMap)existing, relationshipGUID, CLASS_NAME, METHOD_NAME);
            }
            catch (InvalidParameterException e) {
                throw new RelationshipNotDeletedException(XTDBErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(relationshipGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.instanceCanBeUpdated((IPersistentMap)existing, relationshipGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = RestoreRelationship.restoreInstance(userId, (IPersistentMap)existing);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, String userId, String relationshipGUID) throws RelationshipNotKnownException, RelationshipNotDeletedException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            Relationship result = xtdb.getResultingRelationship(docId, results, METHOD_NAME);
            OMRSRepositoryValidator repositoryValidator = xtdb.getRepositoryValidator();
            String repositoryName = xtdb.getRepositoryName();
            repositoryValidator.validateRelationshipFromStore(repositoryName, relationshipGUID, result, METHOD_NAME);
            repositoryValidator.validateRelationshipIsNotDeleted(repositoryName, (InstanceHeader)result, METHOD_NAME);
            return result;
        }
        catch (InvalidParameterException | RelationshipNotDeletedException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), RestoreRelationship.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        RestoreRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

