/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector;

import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.Constants;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntitySummaryMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.PersistenceLayer;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.search.XTDBQuery;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractReadOperation;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AddEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AddEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AddRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ClassifyEntityDetail;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ClassifyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.DeclassifyEntityDetail;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.DeclassifyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.DeleteEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.DeleteRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.PurgeClassificationReferenceCopyEntityDetail;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.PurgeClassificationReferenceCopyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.PurgeEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.PurgeRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReHomeEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReHomeRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReIdentifyEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReIdentifyRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReLinkRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReTypeEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReTypeRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.RestoreEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.RestoreRelationship;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveClassificationReferenceCopyEntityDetail;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveClassificationReferenceCopyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveEntityReferenceCopy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveRelationshipReferenceCopy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UndoEntityUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UndoRelationshipUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityDetailClassification;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityProperties;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityProxyClassification;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityStatus;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateRelationshipProperties;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateRelationshipStatus;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class XTDBOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final Logger log = LoggerFactory.getLogger(XTDBOMRSRepositoryConnector.class);
    private static final String SYNC = "Synchronously";
    private static final String ASYNC = "Asynchronously";
    private IXtdb xtdbAPI = null;
    private boolean luceneConfigured = false;
    private boolean synchronousIndex = true;
    private boolean luceneRegexes = true;

    public void setMetadataCollectionId(String metadataCollectionId) {
        String methodName = "setMetadataCollectionId";
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId != null) {
            try {
                this.metadataCollection = new XTDBOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId, this.auditLog);
            }
            catch (Exception e) {
                throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), "setMetadataCollectionId", (Throwable)e);
            }
        }
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.auditLog.logMessage("start", XTDBAuditCode.REPOSITORY_NODE_STARTING.getMessageDefinition());
        File configFile = null;
        Map configMap = null;
        Map configProperties = this.connectionProperties.getConfigurationProperties();
        if (configProperties != null && !configProperties.isEmpty()) {
            Object luceneReg;
            Object syncIdx;
            Object xtdbCfg;
            if (configProperties.containsKey("xtdbConfig") && (xtdbCfg = configProperties.get("xtdbConfig")) instanceof Map) {
                Object luceneCfg;
                Map xtdbConfig = (Map)xtdbCfg;
                this.luceneConfigured = xtdbConfig.containsKey("xtdb.lucene/lucene-store");
                if (this.luceneConfigured && (luceneCfg = xtdbConfig.get("xtdb.lucene/lucene-store")) instanceof Map) {
                    Map luceneConfig = (Map)luceneCfg;
                    HashMap<String, String> indexer = new HashMap<String, String>();
                    indexer.put("xtdb/module", "xtdb.lucene.egeria/->egeria-indexer");
                    luceneConfig.put("indexer", indexer);
                    HashMap<String, String> analyzer = new HashMap<String, String>();
                    analyzer.put("xtdb/module", "xtdb.lucene.egeria/->ci-analyzer");
                    luceneConfig.put("analyzer", analyzer);
                    xtdbConfig.put("xtdb.lucene/lucene-store", luceneConfig);
                }
                configMap = xtdbConfig;
            }
            if (configProperties.containsKey("xtdbConfigEDN")) {
                try {
                    configFile = File.createTempFile(this.serverName, ".edn", new File("./"));
                    xtdbCfg = (String)configProperties.get("xtdbConfigEDN");
                    this.luceneConfigured = ((String)xtdbCfg).contains("xtdb.lucene/lucene-store");
                    BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
                    writer.write((String)xtdbCfg);
                    writer.close();
                }
                catch (IOException e) {
                    this.auditLog.logException("start", XTDBAuditCode.CANNOT_READ_CONFIGURATION.getMessageDefinition(e.getClass().getName()), (Throwable)e);
                    throw new ConnectorCheckedException(XTDBErrorCode.CANNOT_READ_CONFIGURATION.getMessageDefinition(this.repositoryName), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)e);
                }
            }
            if (configProperties.containsKey("syncIndex") && (syncIdx = configProperties.get("syncIndex")) instanceof Boolean) {
                this.synchronousIndex = (Boolean)syncIdx;
            }
            if (configProperties.containsKey("luceneRegexes") && (luceneReg = configProperties.get("luceneRegexes")) instanceof Boolean) {
                this.luceneRegexes = (Boolean)luceneReg;
            }
        }
        try {
            if (configMap == null && configFile == null) {
                this.auditLog.logMessage("start", XTDBAuditCode.REPOSITORY_NODE_STARTING_NO_CONFIG.getMessageDefinition());
                this.xtdbAPI = IXtdb.startNode();
            } else if (configMap != null) {
                this.auditLog.logMessage("start", XTDBAuditCode.REPOSITORY_NODE_STARTING_WITH_CONFIG.getMessageDefinition());
                log.debug("Starting XTDB with configuration: {}", configMap);
                this.xtdbAPI = IXtdb.startNode(configMap);
            } else {
                this.auditLog.logMessage("start", XTDBAuditCode.REPOSITORY_NODE_STARTING_WITH_CONFIG.getMessageDefinition());
                log.debug("Starting XTDB with configuration: {}", configFile);
                this.xtdbAPI = IXtdb.startNode(configFile);
                Files.delete(Paths.get(configFile.getCanonicalPath(), new String[0]));
            }
            Map details = this.xtdbAPI.status();
            log.info("xtdb config details: {}", (Object)details);
            Object version = details.get(Constants.XTDB_VERSION);
            long persistenceVersion = PersistenceLayer.getVersion(this.xtdbAPI);
            boolean emptyDataStore = this.isDataStoreEmpty();
            if (persistenceVersion == -1L && emptyDataStore) {
                PersistenceLayer.setVersion(this.xtdbAPI, 3L);
            } else if (persistenceVersion != 3L) {
                this.xtdbAPI.close();
                throw new ConnectorCheckedException(XTDBErrorCode.PERSISTENCE_LAYER_MISMATCH.getMessageDefinition("" + persistenceVersion, "3"), ((Object)((Object)this)).getClass().getName(), "start");
            }
            ArrayList<String> opts = new ArrayList<String>();
            opts.add(this.synchronousIndex ? "synchronous indexing" : "asynchronous indexing");
            if (this.luceneConfigured) {
                opts.add("Lucene text index");
                if (this.luceneRegexes) {
                    opts.add("Lucene regexes");
                }
            }
            this.auditLog.logMessage("start", XTDBAuditCode.REPOSITORY_SERVICE_STARTED.getMessageDefinition(version == null ? "<null>" : version.toString(), String.join((CharSequence)", ", opts)));
        }
        catch (Exception e) {
            this.auditLog.logException("start", XTDBAuditCode.FAILED_REPOSITORY_STARTUP.getMessageDefinition(e.getClass().getName()), (Throwable)e);
            throw new ConnectorCheckedException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)e);
        }
        Transaction.Builder tx = Transaction.builder();
        AddEntityProxy.create(tx);
        AddEntity.create(tx);
        UpdateEntityStatus.create(tx);
        UpdateEntityProperties.create(tx);
        UndoEntityUpdate.create(tx);
        RestoreEntity.create(tx);
        ClassifyEntityDetail.create(tx);
        ClassifyEntityProxy.create(tx);
        DeclassifyEntityDetail.create(tx);
        DeclassifyEntityProxy.create(tx);
        UpdateEntityDetailClassification.create(tx);
        UpdateEntityProxyClassification.create(tx);
        AddRelationship.create(tx);
        UpdateRelationshipStatus.create(tx);
        UpdateRelationshipProperties.create(tx);
        UndoRelationshipUpdate.create(tx);
        RestoreRelationship.create(tx);
        DeleteRelationship.create(tx);
        PurgeRelationship.create(tx);
        DeleteEntity.create(tx);
        PurgeEntity.create(tx);
        ReLinkRelationship.create(tx);
        ReIdentifyEntity.create(tx);
        ReIdentifyRelationship.create(tx);
        ReTypeEntity.create(tx);
        ReTypeRelationship.create(tx);
        ReHomeEntity.create(tx);
        ReHomeRelationship.create(tx);
        SaveEntityReferenceCopy.create(tx);
        SaveClassificationReferenceCopyEntityDetail.create(tx);
        SaveClassificationReferenceCopyEntityProxy.create(tx);
        SaveRelationshipReferenceCopy.create(tx);
        PurgeClassificationReferenceCopyEntityDetail.create(tx);
        PurgeClassificationReferenceCopyEntityProxy.create(tx);
        Transaction txn = tx.build();
        log.info("Adding transaction functions: {}", (Object)txn);
        TransactionInstant instant = this.xtdbAPI.submitTx(txn);
        this.xtdbAPI.awaitTx(instant, null);
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        super.disconnect();
        try {
            this.xtdbAPI.close();
        }
        catch (IOException e) {
            if (this.auditLog != null) {
                this.auditLog.logException("disconnect", XTDBAuditCode.FAILED_REPOSITORY_SHUTDOWN.getMessageDefinition(e.getClass().getName()), (Throwable)e);
            }
            throw new ConnectorCheckedException(XTDBErrorCode.FAILED_DISCONNECT.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "disconnect", (Throwable)e);
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", XTDBAuditCode.REPOSITORY_SERVICE_SHUTDOWN.getMessageDefinition(this.getServerName()));
        }
    }

    public boolean isLuceneConfigured() {
        return this.luceneConfigured;
    }

    public boolean expectsLuceneRegexes() {
        return this.luceneRegexes;
    }

    public void logProblem(String className, String methodName, XTDBAuditCode code, Throwable cause, String ... params) {
        String location = className + "::" + methodName;
        if (this.auditLog != null) {
            if (cause != null) {
                this.auditLog.logException(location, code.getMessageDefinition(params), cause);
            } else {
                this.auditLog.logMessage(location, code.getMessageDefinition(params));
            }
        } else {
            log.error("No audit log available -- problem during {}: {}", new Object[]{location, code.getMessageDefinition(params), cause});
        }
    }

    public boolean isDataStoreEmpty() {
        XTDBQuery query = new XTDBQuery();
        ArrayList<IPersistentCollection> conditions = new ArrayList<IPersistentCollection>();
        conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{XTDBQuery.DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.METADATA_COLLECTION_ID), Symbol.intern((String)"_")}));
        query.addConditions(conditions);
        IPersistentMap q = query.getQuery();
        q = q.assoc((Object)Keyword.intern((String)"limit"), (Object)1);
        log.debug("Querying with: {}", (Object)q);
        Collection results = this.xtdbAPI.db().query((Object)q, new Object[0]);
        return results == null || results.isEmpty();
    }

    public void validateCommit(TransactionInstant instant, String methodName) throws Exception {
        if (this.synchronousIndex && !this.xtdbAPI.hasTxCommitted(instant)) {
            Exception e = ErrorMessageCache.get(instant.getId());
            if (e != null) {
                throw e;
            }
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }

    public EntityDetail getResultingEntity(String docId, TransactionInstant instant, String methodName) throws Exception {
        this.validateCommit(instant, methodName);
        if (this.synchronousIndex) {
            EntityDetail ed;
            try (IXtdbDatasource db = this.xtdbAPI.openDB(instant);){
                XtdbDocument result = AbstractReadOperation.getXtdbObjectByReference(db, docId);
                EntityDetailMapping edm = new EntityDetailMapping(this, result);
                ed = edm.toEgeria();
            }
            catch (IOException e) {
                throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)e);
            }
            return ed;
        }
        return null;
    }

    public EntitySummary getResultingEntitySummary(String docId, TransactionInstant instant, String methodName) throws Exception {
        this.validateCommit(instant, methodName);
        if (this.synchronousIndex) {
            EntitySummary es;
            try (IXtdbDatasource db = this.xtdbAPI.openDB(instant);){
                XtdbDocument result = AbstractReadOperation.getXtdbObjectByReference(db, docId);
                EntitySummaryMapping esm = new EntitySummaryMapping(this, result);
                es = esm.toEgeria();
            }
            catch (IOException e) {
                throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)e);
            }
            return es;
        }
        return null;
    }

    public Relationship getResultingRelationship(String docId, TransactionInstant instant, String methodName) throws Exception {
        this.validateCommit(instant, methodName);
        if (this.synchronousIndex) {
            Relationship r;
            try (IXtdbDatasource db = this.xtdbAPI.openDB(instant);){
                XtdbDocument result = AbstractReadOperation.getXtdbObjectByReference(db, docId);
                RelationshipMapping rm = new RelationshipMapping(this, result, db);
                r = rm.toEgeria();
            }
            catch (IOException e) {
                throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)e);
            }
            return r;
        }
        return null;
    }

    public TransactionInstant runTx(Transaction statements) {
        if (log.isDebugEnabled()) {
            log.debug("{} transacting with: {}", (Object)(this.synchronousIndex ? SYNC : ASYNC), (Object)statements);
        }
        TransactionInstant tx = this.xtdbAPI.submitTx(statements);
        if (this.synchronousIndex) {
            return this.xtdbAPI.awaitTx(tx, null);
        }
        return tx;
    }

    public IXtdb getXtdbAPI() {
        return this.xtdbAPI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XTDBOMRSRepositoryConnector that = (XTDBOMRSRepositoryConnector)((Object)o);
        return this.luceneConfigured == that.luceneConfigured && this.synchronousIndex == that.synchronousIndex && this.luceneRegexes == that.luceneRegexes && Objects.equals(this.xtdbAPI, that.xtdbAPI);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.xtdbAPI, this.luceneConfigured, this.synchronousIndex, this.luceneRegexes);
    }
}

