/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.PropertyKeywords;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstancePropertyValueMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class MapPropertyValueMapping
extends InstancePropertyValueMapping {
    public static void addMapPropertyValueToDoc(XTDBOMRSRepositoryConnector xtdbConnector, XtdbDocument.Builder builder, PropertyKeywords keywords, MapPropertyValue value) {
        builder.put(keywords.getSearchablePath(), MapPropertyValueMapping.getMapPropertyValueForComparison(xtdbConnector, value));
    }

    public static IPersistentMap addMapPropertyValueToDoc(IPersistentMap doc, Keyword propertyKeyword, MapPropertyValue value) throws InvalidParameterException {
        return doc.assoc((Object)propertyKeyword, MapPropertyValueMapping.getMapPropertyValueForComparison(value));
    }

    public static Map<String, Object> getMapPropertyValueForComparison(XTDBOMRSRepositoryConnector xtdbConnector, MapPropertyValue mpv) {
        InstanceProperties values = mpv.getMapValues();
        if (values != null && values.getInstanceProperties() != null) {
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            for (Map.Entry entry : values.getInstanceProperties().entrySet()) {
                String key = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                Object toCompare = MapPropertyValueMapping.getValueForComparison(xtdbConnector, value);
                if (toCompare == null) continue;
                results.put(key, toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public static Map<String, Object> getMapPropertyValueForComparison(MapPropertyValue mpv) throws InvalidParameterException {
        InstanceProperties values = mpv.getMapValues();
        if (values != null && values.getInstanceProperties() != null) {
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            for (Map.Entry entry : values.getInstanceProperties().entrySet()) {
                String key = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                Object toCompare = MapPropertyValueMapping.getValueForComparison(value);
                if (toCompare == null) continue;
                results.put(key, toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }
}

