/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.DeleteInstance;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class DeleteRelationship
extends DeleteInstance {
    private static final Logger log = LoggerFactory.getLogger(DeleteRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"deleteRelationship");
    private static final String CLASS_NAME = DeleteRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid user]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db rid)          deleted (.doc (" + DeleteRelationship.class.getCanonicalName() + ". tx-id existing user rid))" + DeleteRelationship.getTxnTimeCalculation("deleted") + "]         [[:xtdb.api/put deleted txt]]))";
    private final IPersistentMap xtdbDoc;

    public DeleteRelationship(Long txId, PersistentHashMap existing, String userId, String obsoleteRelationshipGUID) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(obsoleteRelationshipGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.relationshipFromStore(obsoleteRelationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)existing, obsoleteRelationshipGUID, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = DeleteRelationship.deleteInstance(userId, (IPersistentMap)existing);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, String userId, String relationshipGUID) throws RelationshipNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingRelationship(docId, results, METHOD_NAME);
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("deleteRelationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        DeleteRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

