/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityProxyMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveEntityReferenceCopy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;

public abstract class PurgeClassificationReferenceCopy
extends AbstractTransactionFunction {
    protected final IPersistentMap xtdbDoc;

    public PurgeClassificationReferenceCopy(String className, String methodName, Long txId, PersistentHashMap existing, PersistentHashMap entity, String entityGUID, Classification classification, String homeMetadataCollectionId) throws Exception {
        try {
            PersistentHashMap docToUpdate = null;
            if (homeMetadataCollectionId.equals(classification.getMetadataCollectionId())) {
                throw new PropertyErrorException(XTDBErrorCode.CLASSIFICATION_HOME_COLLECTION_REFERENCE.getMessageDefinition(entityGUID, homeMetadataCollectionId), className, methodName);
            }
            if (existing != null) {
                docToUpdate = existing;
            } else if (!homeMetadataCollectionId.equals(PurgeClassificationReferenceCopy.getMetadataCollectionId((IPersistentMap)entity)) || EntityProxyMapping.isOnlyAProxy((IPersistentMap)entity)) {
                docToUpdate = entity;
            }
            if (docToUpdate != null) {
                try {
                    docToUpdate = ClassificationMapping.removeFromMap((IPersistentMap)docToUpdate, classification.getName());
                }
                catch (ClassificationErrorException e) {
                    docToUpdate = null;
                }
            }
            this.xtdbDoc = docToUpdate;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    protected static String getTxFn(String className) {
        return "(fn [ctx eid e rcc mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + className + ". tx-id existing e eid rcc mid))          nmid (when (some? updated)                     (get updated :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + "))" + PurgeClassificationReferenceCopy.getTxnTimeCalculation("updated") + "]         (when (some? nmid)          (if (= mid nmid)            [[:xtdb.api/put updated txt]]            [[:xtdb.api/fn " + SaveEntityReferenceCopy.FUNCTION_NAME + " eid updated mid]]))))";
    }
}

