/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityProxyMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AddEntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class SaveRelationshipReferenceCopy
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(SaveRelationshipReferenceCopy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"saveRelationshipReferenceCopy");
    private static final String CLASS_NAME = SaveRelationshipReferenceCopy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid eid1 eid2 rcr rcp1 rcp2 mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          proxy1 (xtdb.api/entity db eid1)          proxy2 (xtdb.api/entity db eid2)          existing (xtdb.api/entity db rid)          updated (.doc (" + SaveRelationshipReferenceCopy.class.getCanonicalName() + ". tx-id existing rcr mid))" + SaveRelationshipReferenceCopy.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/fn " + AddEntityProxy.FUNCTION_NAME + " eid1 rcp1]          [:xtdb.api/fn " + AddEntityProxy.FUNCTION_NAME + " eid2 rcp2]          [:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public SaveRelationshipReferenceCopy(Long txId, PersistentHashMap existing, PersistentHashMap updated, String homeMetadataCollectionId) throws Exception {
        try {
            String rcMetadataCollectionId = SaveRelationshipReferenceCopy.getMetadataCollectionId((IPersistentMap)updated);
            if (rcMetadataCollectionId.equals(homeMetadataCollectionId)) {
                throw new HomeRelationshipException(XTDBErrorCode.RELATIONSHIP_HOME_COLLECTION_REFERENCE.getMessageDefinition(SaveRelationshipReferenceCopy.getGUID((IPersistentMap)updated), homeMetadataCollectionId), CLASS_NAME, METHOD_NAME);
            }
            if (existing == null) {
                this.xtdbDoc = updated;
            } else {
                String exMetadataCollectionId = SaveRelationshipReferenceCopy.getMetadataCollectionId((IPersistentMap)existing);
                if (!rcMetadataCollectionId.equals(exMetadataCollectionId)) {
                    throw new RelationshipConflictException(XTDBErrorCode.METADATA_COLLECTION_CONFLICT.getMessageDefinition(SaveRelationshipReferenceCopy.getGUID((IPersistentMap)updated)), CLASS_NAME, METHOD_NAME);
                }
                this.xtdbDoc = updated;
            }
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transact(XTDBOMRSRepositoryConnector xtdb, Relationship toSave) throws RelationshipConflictException, HomeRelationshipException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(toSave.getGUID());
        EntityProxy ep1 = toSave.getEntityOneProxy();
        EntityProxy ep2 = toSave.getEntityTwoProxy();
        EntityProxyMapping epm1 = new EntityProxyMapping(xtdb, ep1);
        EntityProxyMapping epm2 = new EntityProxyMapping(xtdb, ep2);
        XtdbDocument ep1XT = epm1.toXTDB();
        XtdbDocument ep2XT = epm2.toXTDB();
        String proxy1Id = EntityDetailMapping.getReference(ep1.getGUID());
        String proxy2Id = EntityDetailMapping.getReference(ep2.getGUID());
        RelationshipMapping rm = new RelationshipMapping(xtdb, toSave);
        XtdbDocument toSaveXT = rm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, proxy1Id, proxy2Id, toSaveXT.toMap(), ep1XT.toMap(), ep2XT.toMap(), xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (HomeRelationshipException | InvalidParameterException | RelationshipConflictException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        SaveRelationshipReferenceCopy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

