/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.Keywords;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UndoInstanceUpdate;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.ICursor;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UndoEntityUpdate
extends UndoInstanceUpdate {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityProperties.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"undoEntityUpdate");
    private static final String CLASS_NAME = UndoEntityUpdate.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user mid]     (with-open [history (xtdb.api/open-entity-history (xtdb.api/db ctx) eid :desc {:with-docs? true})]      (let [tx-id (:xtdb.api/tx-id (xtdb.api/indexing-tx ctx))            updated (.doc (" + UndoEntityUpdate.class.getCanonicalName() + ". tx-id history user eid mid))" + UndoEntityUpdate.getTxnTimeCalculation("updated") + "]           [[:xtdb.api/put updated txt]])))";
    private final IPersistentMap xtdbDoc;

    public UndoEntityUpdate(Long txId, ICursor<IPersistentMap> cursor, String userId, String entityGUID, String metadataCollectionId) throws Exception {
        try {
            IPersistentVector history = UndoEntityUpdate.getPreviousVersionFromCursor(cursor);
            if (history.length() == 0) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), this.getClass().getName(), METHOD_NAME);
            }
            IPersistentMap current = (IPersistentMap)history.nth(0);
            if (current == null) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), this.getClass().getName(), METHOD_NAME);
            }
            if (history.length() == 2) {
                IPersistentMap previous = (IPersistentMap)history.nth(1);
                TxnValidations.nonProxyEntity(current, entityGUID, CLASS_NAME, METHOD_NAME);
                TxnValidations.instanceCanBeUpdated(current, entityGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
                this.xtdbDoc = UndoEntityUpdate.rollbackEntity(userId, current, previous);
            } else {
                this.xtdbDoc = current;
            }
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XTDBOMRSRepositoryConnector xtdb, String userId, String entityGUID) throws EntityNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            EntityDetail result = xtdb.getResultingEntity(docId, results, METHOD_NAME);
            OMRSRepositoryValidator repositoryValidator = xtdb.getRepositoryValidator();
            String repositoryName = xtdb.getRepositoryName();
            repositoryValidator.validateEntityFromStore(repositoryName, entityGUID, result, METHOD_NAME);
            repositoryValidator.validateEntityIsNotDeleted(repositoryName, (InstanceHeader)result, METHOD_NAME);
            return result;
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), UndoEntityUpdate.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UndoEntityUpdate.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }

    public static IPersistentMap rollbackEntity(String userId, IPersistentMap current, IPersistentMap previous) {
        Long currentVersion = (Long)current.valAt((Object)Keywords.VERSION);
        IPersistentMap doc = UndoEntityUpdate.incrementVersion(userId, previous);
        doc = doc.assoc((Object)Keywords.VERSION, (Object)(currentVersion + 1L));
        for (MapEntry entry : previous) {
            Object key = entry.getKey();
            String keyName = key.toString();
            if (!keyName.startsWith(":classifications") && !keyName.equals(":lastClassificationChange")) continue;
            doc = doc.without(key);
        }
        for (MapEntry entry : current) {
            Object key = entry.getKey();
            String keyName = key.toString();
            if (!keyName.startsWith(":classifications") && !keyName.equals(":lastClassificationChange")) continue;
            doc = doc.assoc(key, entry.getValue());
        }
        return doc;
    }
}

