/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateInstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UpdateEntityProperties
extends UpdateInstanceProperties {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityProperties.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"updateEntityProperties");
    private static final String CLASS_NAME = UpdateEntityProperties.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user properties mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + UpdateEntityProperties.class.getCanonicalName() + ". tx-id existing user eid mid properties))" + UpdateEntityProperties.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public UpdateEntityProperties(Long txId, PersistentHashMap existing, String userId, String entityGUID, String metadataCollectionId, InstanceProperties properties) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), this.getClass().getName(), METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            UpdateEntityProperties.validate((IPersistentMap)existing, entityGUID, metadataCollectionId, properties, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = UpdateEntityProperties.updateInstanceProperties(userId, (IPersistentMap)existing, properties);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XTDBOMRSRepositoryConnector xtdb, String userId, String entityGUID, InstanceProperties properties) throws EntityNotKnownException, InvalidParameterException, PropertyErrorException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, properties, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (EntityNotKnownException | InvalidParameterException | PropertyErrorException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), UpdateEntityProperties.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UpdateEntityProperties.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

