/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import java.util.Date;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.TypeDefCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstancePropertiesMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.Keywords;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityClassification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class UpdateInstanceProperties
extends AbstractTransactionFunction {
    protected static IPersistentMap updateInstanceProperties(String userId, IPersistentMap existing, InstanceProperties properties) throws InvalidParameterException, IOException, ClassificationErrorException {
        return UpdateInstanceProperties.updateInstanceProperties(userId, existing, properties, null);
    }

    protected static IPersistentMap updateInstanceProperties(String userId, IPersistentMap existing, InstanceProperties properties, String classificationName) throws InvalidParameterException, IOException, ClassificationErrorException {
        String typeDefGUID;
        String methodName = "updateInstanceProperties";
        IPersistentMap doc = UpdateInstanceProperties.incrementVersion(userId, existing, classificationName);
        if (classificationName == null) {
            typeDefGUID = UpdateInstanceProperties.getTypeDefGUID(existing);
        } else {
            TypeDef classificationTypeDef = TypeDefCache.getTypeDefByName(classificationName);
            if (classificationTypeDef == null) {
                throw new ClassificationErrorException(XTDBErrorCode.INVALID_TYPEDEF.getMessageDefinition(classificationName), TxnValidations.class.getName(), "updateInstanceProperties");
            }
            typeDefGUID = classificationTypeDef.getGUID();
            ClassificationMapping.validateHasClassification(existing, classificationName, UpdateEntityClassification.CLASS_NAME, UpdateEntityClassification.METHOD_NAME);
            doc = doc.assoc((Object)Keywords.LAST_CLASSIFICATION_CHANGE, (Object)new Date());
        }
        return InstancePropertiesMapping.addToMap(doc, typeDefGUID, properties);
    }

    protected static void validate(IPersistentMap existing, String instanceGUID, String metadataCollectionId, InstanceProperties properties, String className, String methodName) throws InvalidParameterException, RepositoryErrorException, IOException, PropertyErrorException {
        TxnValidations.instanceIsNotDeleted(existing, instanceGUID, className, methodName);
        TxnValidations.instanceCanBeUpdated(existing, instanceGUID, metadataCollectionId, className, methodName);
        TxnValidations.instanceType(existing, className, methodName);
        TypeDef typeDef = UpdateInstanceProperties.getTypeDefForInstance(existing);
        TxnValidations.propertiesForType(typeDef, properties, className, methodName);
    }
}

