/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityStatus;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateInstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UpdateRelationshipStatus
extends UpdateInstanceStatus {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityStatus.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"updateRelationshipStatus");
    private static final String CLASS_NAME = UpdateRelationshipStatus.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid user status mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db rid)          updated (.doc (" + UpdateRelationshipStatus.class.getCanonicalName() + ". tx-id existing user rid mid status))" + UpdateRelationshipStatus.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public UpdateRelationshipStatus(Long txId, PersistentHashMap existing, String userId, String relationshipGUID, String metadataCollectionId, Integer instanceStatus) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), this.getClass().getName(), METHOD_NAME);
            }
            TxnValidations.relationshipFromStore(relationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            UpdateRelationshipStatus.validate((IPersistentMap)existing, relationshipGUID, metadataCollectionId, instanceStatus, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = UpdateRelationshipStatus.updateInstanceStatus(userId, (IPersistentMap)existing, instanceStatus);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, String userId, String relationshipGUID, InstanceStatus newStatus) throws RelationshipNotKnownException, StatusNotSupportedException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, newStatus.getOrdinal(), xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingRelationship(docId, results, METHOD_NAME);
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException | StatusNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UpdateRelationshipStatus.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

