/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import java.io.IOException;
import java.util.Date;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractReadOperation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class GetRelationship
extends AbstractReadOperation {
    private static final Logger log = LoggerFactory.getLogger(GetRelationship.class);
    private final String guid;

    public GetRelationship(XTDBOMRSRepositoryConnector xtdb, String guid, Date asOfTime) {
        super(xtdb, asOfTime);
        this.guid = guid;
    }

    public Relationship execute() throws RepositoryErrorException {
        Relationship r;
        String methodName = "getRelationship";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            r = GetRelationship.byRef(this.xtdb, db, RelationshipMapping.getReference(this.guid));
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getRelationship", (Throwable)e);
        }
        return r;
    }

    public static Relationship byRef(XTDBOMRSRepositoryConnector xtdb, IXtdbDatasource db, String ref) {
        XtdbDocument xtdbDoc = GetRelationship.getXtdbObjectByReference(db, ref);
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(xtdbDoc == null ? null : xtdbDoc.toMap()));
        }
        if (xtdbDoc != null) {
            RelationshipMapping rm = new RelationshipMapping(xtdb, xtdbDoc, db);
            return rm.toEgeria();
        }
        return null;
    }
}

