/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EnumPropertyValueMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.Keywords;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;

public abstract class ReHomeInstance
extends AbstractTransactionFunction {
    protected static IPersistentMap reHomeInstance(String userId, IPersistentMap existing, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) {
        IPersistentMap doc = ReHomeInstance.incrementVersion(userId, existing);
        return doc.assoc((Object)Keywords.METADATA_COLLECTION_ID, (Object)newHomeMetadataCollectionId).assoc((Object)Keywords.METADATA_COLLECTION_NAME, (Object)newHomeMetadataCollectionName).assoc((Object)Keywords.INSTANCE_PROVENANCE_TYPE, (Object)EnumPropertyValueMapping.getOrdinalForInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT));
    }

    protected static void validate(IPersistentMap existing, String metadataCollectionId, String className, String methodName) throws InvalidParameterException {
        boolean updateAllowed = false;
        Integer instanceProvenance = ReHomeInstance.getInstanceProvenanceType(existing);
        if (instanceProvenance != null) {
            String replicatedBy;
            if (instanceProvenance.intValue() == InstanceProvenanceType.LOCAL_COHORT.getOrdinal()) {
                String entityHome = ReHomeInstance.getMetadataCollectionId(existing);
                if (entityHome != null && !entityHome.equals(metadataCollectionId)) {
                    updateAllowed = true;
                }
            } else if (instanceProvenance.intValue() == InstanceProvenanceType.EXTERNAL_SOURCE.getOrdinal() && (replicatedBy = (String)existing.valAt((Object)Keywords.REPLICATED_BY)) != null && !replicatedBy.equals(metadataCollectionId)) {
                updateAllowed = true;
            }
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(XTDBErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(ReHomeInstance.getMetadataCollectionId(existing), ReHomeInstance.getGUID(existing), metadataCollectionId), className, methodName, "instance");
        }
    }
}

