/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBAuditCode;

public abstract class AbstractMapping {
    protected final XTDBOMRSRepositoryConnector xtdbConnector;
    protected static final ObjectMapper mapper = new ObjectMapper();
    private static final Keyword EMBEDDED_JSON = Keyword.intern((String)"json");

    protected AbstractMapping() {
        this.xtdbConnector = null;
    }

    protected AbstractMapping(XTDBOMRSRepositoryConnector xtdbConnector) {
        this.xtdbConnector = xtdbConnector;
    }

    public static String getKeyword(String name) {
        return AbstractMapping.getKeyword(null, name);
    }

    public static String getKeyword(String namespace, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (namespace == null || namespace.length() == 0) {
            return name;
        }
        return namespace + "/" + name;
    }

    protected static IPersistentMap getEmbeddedSerializedForm(XTDBOMRSRepositoryConnector xtdbConnector, String type, String property, Object value) {
        IPersistentMap subMap = null;
        if (value != null) {
            try {
                String json = mapper.writeValueAsString(value);
                HashMap<Keyword, String> map = new HashMap<Keyword, String>();
                map.put(EMBEDDED_JSON, json);
                subMap = PersistentHashMap.create(map);
            }
            catch (IOException e) {
                xtdbConnector.logProblem(AbstractMapping.class.getName(), "getEmbeddedSerializedForm", XTDBAuditCode.SERIALIZATION_FAILURE, e, property, type, e.getClass().getName());
            }
        }
        return subMap;
    }

    protected static IPersistentMap getEmbeddedSerializedForm(Object value) throws IOException {
        IPersistentMap subMap = null;
        if (value != null) {
            String json = mapper.writeValueAsString(value);
            HashMap<Keyword, String> map = new HashMap<Keyword, String>();
            map.put(EMBEDDED_JSON, json);
            subMap = PersistentHashMap.create(map);
        }
        return subMap;
    }

    protected static <T> T getDeserializedValue(XTDBOMRSRepositoryConnector xtdbConnector, String type, String property, IPersistentMap embedded, JavaType javaType) {
        Object deserialized = null;
        if (embedded != null && embedded.containsKey((Object)EMBEDDED_JSON)) {
            String value = (String)embedded.valAt((Object)EMBEDDED_JSON);
            try {
                deserialized = mapper.readValue(value, javaType);
            }
            catch (IOException e) {
                xtdbConnector.logProblem(AbstractMapping.class.getName(), "getEmbeddedSerializedForm", XTDBAuditCode.DESERIALIZATION_FAILURE, e, property, type, javaType.getTypeName(), e.getClass().getName());
            }
        }
        return (T)deserialized;
    }

    protected static <T> T getDeserializedValue(IPersistentMap embedded, JavaType javaType) throws IOException {
        Object deserialized = null;
        if (embedded != null && embedded.containsKey((Object)EMBEDDED_JSON)) {
            String value = (String)embedded.valAt((Object)EMBEDDED_JSON);
            deserialized = mapper.readValue(value, javaType);
        }
        return (T)deserialized;
    }
}

