/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceHeaderMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class EntitySummaryMapping
extends InstanceHeaderMapping {
    public static final String INSTANCE_REF_PREFIX = "e";
    public static final String N_CLASSIFICATIONS = "classifications";

    public EntitySummaryMapping(XTDBOMRSRepositoryConnector xtdbConnector, EntitySummary entitySummary) {
        super(xtdbConnector, (InstanceHeader)entitySummary);
    }

    public EntitySummaryMapping(XTDBOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc) {
        super(xtdbConnector, xtdbDoc);
    }

    public EntitySummary toEgeria() {
        if (this.instanceHeader == null && this.xtdbDoc != null) {
            this.instanceHeader = new EntitySummary();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (EntitySummary)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected XtdbDocument.Builder toDoc() {
        XtdbDocument.Builder builder = super.toDoc();
        List classifications = ((EntitySummary)this.instanceHeader).getClassifications();
        ClassificationMapping cm = new ClassificationMapping(this.xtdbConnector, classifications);
        cm.addToXtdbDoc(builder);
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        ClassificationMapping cm = new ClassificationMapping(this.xtdbConnector, this.xtdbDoc);
        List<Classification> classifications = cm.toEgeria();
        ((EntitySummary)this.instanceHeader).setClassifications(classifications);
    }

    protected static void fromMap(EntitySummary es, IPersistentMap doc) throws IOException, InvalidParameterException {
        InstanceHeaderMapping.fromMap((InstanceHeader)es, doc);
        List<Classification> classifications = ClassificationMapping.fromMap(doc);
        es.setClassifications(classifications);
    }

    public static String getReference(String guid) {
        return EntitySummaryMapping.getReference(INSTANCE_REF_PREFIX, guid);
    }
}

